<?php

use yii\helpers\Html;
use yii\grid\GridView;
use app\models\Uzers;

/* @var $this yii\web\View */
/* @var $searchModel app\models\LeavesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'List of leaves';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="leaves-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>


    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

             [
                'attribute'=>'userId',
                'value'=>function ($model, $key, $index, $widget) {return  Uzers::findOne($model->userId)->fullName; }
            ],
            [
                'attribute'=>'startdate',
                'value'=>function ($model, $key, $index, $widget) {return  date('d-m-Y',strtotime($model->startdate)); },
            ],
                
            [
                'attribute'=>'enddate',
                'value'=>function ($model, $key, $index, $widget) {return  date('d-m-Y',strtotime($model->enddate)); },
            ],
            [
                'attribute'=>'days',
                'value'=>function ($model, $key, $index, $widget) {return  Uzers::getdaysdifference($model->startdate,$model->enddate); },
            ],

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
