<?php

/* @var $this \yii\web\View */
/* @var $content string */

use app\models\Uzers;
use app\widgets\Alert;
use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use app\assets\AppAsset;
use kartik\sidenav\SideNav;


AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php $this->registerCsrfMetaTags() ?>
     <?php $name=Uzers::getCompanyname(\Yii::$app->session->get('company')); ?>
    
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body>
<?php $this->beginBody() ?>

<div class="wrap">

    <?php
    
    NavBar::begin([
        'brandLabel' => Yii::$app->name.' - '.$name,
        'brandUrl' => Yii::$app->homeUrl,
        'options' => [
            'class' => 'navbar-inverse navbar-fixed-top',
        ],
    ]);
    
 
  
    echo Nav::widget([
        'options' => ['class' => 'navbar-nav navbar-right'],
        'items' => [
            ['label' => 'Home', 'url' => ['/uzers/dashboard']],
            ['label' => 'Cars', 'url' => ['/cars/index']],
            ['label' =>'Movements', 'url' => ['#'],
                'items' => [
                    ['label' =>'Movements', 'url' => ['/movements/index']],
                    ['label' =>'Movements summary', 'url' => ['/movements/clientmovementsbydate']],
                    ['label' =>'Clients lists', 'url' => ['/fromclients/index']],
                     ['label' =>'Officer performance', 'url' => ['/movements/officerstrengthbydate']],
                ],
            ],
            ['label' =>'Fuel', 'url' => ['#'],
                'items' => [
                    ['label' =>'New request', 'url' => ['/fuelrequest/carselect']],
                    ['label' =>'All records', 'url' => ['/fuelrequest/index']],
                    ['label' =>'Tire services', 'url' => ['/tireservices/index']],
                    ['label' =>'Borrowed consupt', 'url' => ['/fuelrequest/borrowedlist']],
                    ['label' =>'Reserve consupt', 'url' => ['/fuelrequest/reservelist']],
                    ['label' =>'Consumpt by car', 'url' => ['/fuelrequest/truckmovesfuelbytime']],
                ],
            ],
            ['label' =>'Drivers', 'url' => ['#'],
                'items' => [
                    ['label' =>'Drivers list', 'url' => ['/cardrivers/index']],
                    ['label' =>'Incentives(all)', 'url' => ['/movements/driversincentive','id'=>1]],
                    ['label' =>'incentive(single)', 'url' => ['/movements/incentivebydriver','id'=>1]],
                ],
            ],
            ['label' =>'Offences & depts', 'url' => ['#'],
                'items' => [
                    ['label' =>'Traffic', 'url' => ['/trafficoffences/index']],
                    ['label' =>'Depts', 'url' => ['/trafficoffences/indexdepts']],
                ],
            ],
            ['label' =>'Bills & payments', 'url' => ['/bills/index']],
            ['label' =>'Statistics', 'url' => ['/statistics/index']],
            ['label' => 'Setting', 'url' => ['#'],
                'items' => [
                    ['label' =>'Users', 'url' => ['/uzers/index']],
                    ['label' =>'Cars', 'url' => ['/cars/index']],
                    ['label' =>'Clients', 'url' => ['/clients/index']],
                    ['label' =>'Movement types', 'url' => ['/movetype/index']],
                    ['label' => 'Change Password', 'url' => ['/uzers/changepassword','id'=>Yii::$app->user->getId()]],
                ],
            ],
            
            Yii::$app->user->isGuest ? (
                ['label' => 'Login', 'url' => ['/site/login']]
            ) : (
                '<li>'
                . Html::beginForm(['/site/logout'], 'post')
                . Html::submitButton(
                    'Logout (' . Yii::$app->user->identity->username . ')',
                    ['class' => 'btn btn-link logout']
                )
                . Html::endForm()
                . '</li>'
            ),
        ],
    ]);
    
    
    NavBar::end();
    ?>

    <div class="container">
        <?= Breadcrumbs::widget([
            'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
        ]) ?>
        <?= Alert::widget() ?>
        
            
        <div class="col-lg-2">
          <?php
    
        echo SideNav::widget([
            'type' => SideNav::TYPE_PRIMARY,
            'encodeLabels' => false,
            'heading' => 'Operations',
            'items' => [
                ['label' => 'Cars', 'url' => ['/cars/index']],
                ['label' =>'Movements', 'url' => ['#'],
                    'items' => [
                        ['label' =>'Movements', 'url' => ['/movements/index']],
                        ['label' =>'Movements summary', 'url' => ['/movements/clientmovementsbydate']],
                        ['label' =>'Officer performance', 'url' => ['/movements/officerstrengthbydate']],
                    ],
                ],
                ['label' =>'Fuel', 'url' => ['#'],
                    'items' => [
                        ['label' =>'New request', 'url' => ['/fuelrequest/carselect']],
                        ['label' =>'All records', 'url' => ['/fuelrequest/index']],
                        ['label' =>'Tire services', 'url' => ['/tireservices/index']],
                        ['label' =>'Borrowed consupt', 'url' => ['/fuelrequest/borrowedlist']],
                        ['label' =>'Reserve consupt', 'url' => ['/fuelrequest/reservelist']],
                    ],
                ],
                ['label' =>'Drivers', 'url' => ['#'],
                    'items' => [
                        ['label' =>'Drivers list', 'url' => ['/cardrivers/index']],
                        ['label' =>'Incentives', 'url' => ['/movements/driversincentive','id'=>1]],
                    ],
                ],
                ['label' => 'Traffic offences', 'url' => ['/trafficoffences/index']],
                ['label' =>'Statistics', 'url' => ['/statistics/index']],
                ],
        ]);  
            
    ?>
    
    </div>
         
         <div class="col-lg-9">
        
        <?= $content ?>
        </div>
    </div>
</div>

<footer class="footer">
    <div class="container">
        <p class="pull-left">&copy; Logi'ERP <?= date('Y') ?></p>

        <p class="pull-right"> Assuretec (T) Ltd </p>
    </div>
</footer>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>