<?php

/* @var $this \yii\web\View */
/* @var $content string */

use app\widgets\Alert;
use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use app\assets\AppAsset;
use kartik\sidenav\SideNav;
use app\models\Uzers;


AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php $this->registerCsrfMetaTags() ?>
    <?php $name=Uzers::getCompanyname(\Yii::$app->session->get('company')); ?>
    <link rel="stylesheet" href="<?php echo Yii::$app->request->baseUrl; ?>/app/css/bootstrap.css">
    <link rel="stylesheet" href="<?php echo Yii::$app->request->baseUrl; ?>/app/css/app.css">
    
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body>
<?php $this->beginBody() ?>

<div class="wrap">

    <?php
    
    NavBar::begin([
        'brandLabel' => Yii::$app->name.' - '.$name,
        'brandUrl' => Yii::$app->homeUrl,
        'options' => [
            'class' => 'navbar-inverse navbar-fixed-top',
        ],
    ]);
   
 
  
    echo Nav::widget([
        'options' => ['class' => 'navbar-nav navbar-right'],
        'items' => [
            ['label' => 'Home', 'url' => ['/uzers/dashboard']],
            ['label' => 'Moves Ops', 'url' => ['/movements/index']],
            ['label' => 'Workshops', 'url' => ['/wstore/index']],
            ['label' => 'C&F Ops', 'url' => ['/cfile/index']],
            ['label' => 'Accounts', 'url' => ['/accounts/index']],
            ['label' => 'Reports', 'url' => ['#'],
                'items' => [
                    //['label' =>'statistics report', 'url' => ['/statistics/stats']],
                    ['label' =>'fuel report', 'url' => ['/fuelrequest/report']],
                    ['label' =>'fuel report-Bill', 'url' => ['/fuelrequest/reportbill']],
                    ['label' =>'Non-Op fuel', 'url' => ['/offuels/report']],
                    //['label' =>'Tire services', 'url' => ['/tireservices/report']],
                    //['label' =>'workshop status', 'url' => ['/defectivetrucks/statusreport']],
                   // ['label' =>'spare utilization', 'url' => ['/wstoredispatch/report']],
                    ['label' =>'road offences', 'url' => ['/trafficoffences/report']],
                    //['label' =>'Management report', 'url' => ['/movements/report']],
                    ['label' =>'Management statistics', 'url' => ['/statistics/report']],
                ],
            ],
             
            ['label' => 'Hr', 'url' => ['/salaries/indexhr'], ],
            ['label' => 'Setting', 'url' => ['/uzers/index'],
                'items' => [
                    ['label' =>'Users', 'url' => ['/uzers/index']],
                    ['label' =>'Cars', 'url' => ['/cars/index']],
                    ['label' =>'Car models', 'url' => ['/cartype/index']],
                    ['label' =>'Clients', 'url' => ['/clients/index']],
                    ['label' =>'Movement types', 'url' => ['/movetype/index']],
                    ['label' => 'Change Password', 'url' => ['/uzers/changepassword','id'=>Yii::$app->user->getId()]],
                ],
            ],
            Yii::$app->user->isGuest ? (
                ['label' => 'Login', 'url' => ['/site/login']]
            ) : (
                '<li>'
                . Html::beginForm(['/site/logout'], 'post')
                . Html::submitButton(
                    'Logout (' . Yii::$app->user->identity->username . ')',
                    ['class' => 'btn btn-link logout']
                )
                . Html::endForm()
                . '</li>'
            ),
            Yii::$app->user->can('Admin') ?(
            ['label' => 'Permission',
                'items' => [
                    ['label' =>'Assignment', 'url' => ['/admin/assignment']],
                    ['label' =>'Roles', 'url' => ['/admin/role']],
                    ['label' =>'Routes', 'url' => ['/admin/route']],
                    ['label' =>'Permission', 'url' => ['/admin/permission']],
                   
                ],
                ] ):'',
        ],
    ]);
    
    
    NavBar::end();
    ?>

    <div class="container">
        <?= Breadcrumbs::widget([
            'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
        ]) ?>
        <?= Alert::widget() ?>
        
                
        <div class="col-lg-2">
            
          <?php
    
        echo SideNav::widget([
            'type' => SideNav::TYPE_PRIMARY,
            'encodeLabels' => false,
            'heading' => 'Settings',
            'items' => [
                ['label' =>'Users', 'url' => ['/uzers/index']],
                ['label' =>'Cars', 'url' => ['/cars/index']],
                ['label' =>'Car models', 'url' => ['/cartype/index']],
                ['label' =>'Clients', 'url' => ['/clients/index']],
                ['label' =>'Movement types', 'url' => ['/movetype/index']],
                ['label' => 'Companies', 'url' => ['#'],
                    'items' => [
                        ['label' =>'ITL', 'url' => ['/site/changecompany','id'=>1]],
                        ['label' =>'IMSL', 'url' => ['/site/changecompany','id'=>2]],
                        ['label' =>'EBM TZ', 'url' => ['/site/changecompany','id'=>3]],
                        ['label' =>'TASHICOL', 'url' => ['/site/changecompany','id'=>4]],
                        ['label' =>'EB 25', 'url' => ['/site/changecompany','id'=>5]],
                        ['label' =>'PICD', 'url' => ['/site/changecompany','id'=>6]],
                        ['label' =>'NoC', 'url' => ['/site/changecompany','id'=>0]]
                    ],
                ],
                ['label' => 'Change Password', 'url' => ['/uzers/changepassword','id'=>Yii::$app->user->getId()]],
            ],
        ]);  
            
    ?>
    
    </div>
        
        
        <div class="col-lg-9">
         
        <?= $content ?>
       
       		</div>
       
    </div>
</div>

<footer class="footer">
    <div class="container">
        <p class="pull-left">&copy; Logi'ERP <?= date('Y') ?></p>

        <p class="pull-right"> Assuretec (T) Ltd </p>
    </div>
</footer>

<?php $this->endBody() ?>
 <script src="<?php echo Yii::$app->request->baseUrl; ?>/app/js/app.js"></script> 
</body>
</html>
<?php $this->endPage() ?>