<?php

/* @var $this \yii\web\View */
/* @var $content string */

use app\widgets\Alert;
use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use app\assets\AppAsset;
use kartik\sidenav\SideNav;
use app\models\Uzers;

AppAsset::register($this);

?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php $this->registerCsrfMetaTags() ?>
    <?php $name=Uzers::getCompanyname(\Yii::$app->session->get('company')); ?>
    <link rel="stylesheet" href="<?php echo Yii::$app->request->baseUrl; ?>/app/css/bootstrap.css">
    <link rel="stylesheet" href="<?php echo Yii::$app->request->baseUrl; ?>/app/css/app.css">
    
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body>
<?php $this->beginBody() ?>

<div class="wrap">

    <?php
    
    NavBar::begin([
        'brandLabel' => Yii::$app->name.' - '.$name,
        'brandUrl' => Yii::$app->homeUrl,
        'options' => [
            'class' => 'navbar-inverse navbar-fixed-top',
        ],
    ]);
   
 
  
    echo Nav::widget([
        'options' => ['class' => 'navbar-nav navbar-right'],
        'items' => [
            ['label' => 'Home', 'url' => ['/uzers/dashboard']],
            ['label' =>'Salaries', 'url' => ['/salaries/index']],
            ['label' =>'Overtime', 'url' => ['/overtime/index']],
            ['label' =>'Deductions', 'url' => ['#']],
            ['label' =>'printouts', 'url' => ['/salaries/printouts']],
            ['label' =>'Clients', 'url' => ['/clients/index']],
            ['label' => 'Staffs', 'url' => ['#'],
                'items' => [
                    ['label' =>'staffs', 'url' => ['/uzers/index']],
                    ['label' =>'all leaves', 'url' => ['/leaves/index']],
                    ['label' =>'leaves report', 'url' => ['/leaves/report']],
                ],
            ],
            
            
            Yii::$app->user->isGuest ? (
                ['label' => 'Login', 'url' => ['/site/login']]
            ) : (
                '<li>'
                . Html::beginForm(['/site/logout'], 'post')
                . Html::submitButton(
                    'Logout (' . Yii::$app->user->identity->username . ')',
                    ['class' => 'btn btn-link logout']
                )
                . Html::endForm()
                . '</li>'
            ),
            Yii::$app->user->can('Admin') ?(
            ['label' => 'Permission',
                'items' => [
                    ['label' =>'Assignment', 'url' => ['/admin/assignment']],
                    ['label' =>'Roles', 'url' => ['/admin/role']],
                    ['label' =>'Routes', 'url' => ['/admin/route']],
                    ['label' =>'Permission', 'url' => ['/admin/permission']],
                   
                ],
                ] ):'',
        ],
    ]);
    
    
    NavBar::end();
    ?>

    <div class="container">
        <?= Breadcrumbs::widget([
            'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
        ]) ?>
        <?= Alert::widget() ?>
        <?= $content ?>
       
    </div>
</div>

<footer class="footer">
    <div class="container">
        <p class="pull-left">&copy; Logi'ERP <?= date('Y') ?></p>

        <p class="pull-right"> Assuretec (T) Ltd </p>
    </div>
</footer>

<?php $this->endBody() ?>
 <script src="<?php echo Yii::$app->request->baseUrl; ?>/app/js/app.js"></script> 
</body>
</html>
<?php $this->endPage() ?>
