<?php

/* @var $this \yii\web\View */
/* @var $content string */

use app\models\Uzers;
use app\widgets\Alert;
use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use app\assets\AppAsset;
use kartik\sidenav\SideNav;


AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php $this->registerCsrfMetaTags() ?>
    <?php $name=Uzers::getCompanyname(\Yii::$app->session->get('company')); ?>
    
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body>
<?php $this->beginBody() ?>

<div class="wrap">

    <?php
    
    NavBar::begin([
        'brandLabel' => Yii::$app->name.' - '.$name,
        'brandUrl' => Yii::$app->homeUrl,
        'options' => [
            'class' => 'navbar-inverse navbar-fixed-top',
        ],
    ]);
    
 
  
    echo Nav::widget([
        'options' => ['class' => 'navbar-nav navbar-right'],
        'items' => [
            ['label' => 'Home', 'url' => ['/uzers/dashboard']],
            ['label' => 'Files', 'url' => ['/cfile/index']],
            ['label' => 'Attachments', 'url' => ['/docsupload/index','id'=>\Yii::$app->session->get('fileId')]],
            ['label' => 'Packages', 'url' => ['/packages/index']],
            ['label' => 'Request', 'url' => ['/cfbills/index']],
            ['label' => 'Invoices', 'url' => ['/invoices/index']],
            ['label' =>'Routes', 'url' => ['/routing/index']],
            ['label' => 'Setting', 'url' => ['#'],
                'items' => [
                    ['label' =>'Users', 'url' => ['/uzers/index']],
                    ['label' =>'Cars', 'url' => ['/cars/index']],
                    ['label' =>'Clients', 'url' => ['/clients/index']],
                    ['label' =>'Movement types', 'url' => ['/movetype/index']],
                    ['label' => 'Change Password', 'url' => ['/uzers/changepassword','id'=>Yii::$app->user->getId()]],
                ],
            ],
            
            Yii::$app->user->isGuest ? (
                ['label' => 'Login', 'url' => ['/site/login']]
            ) : (
                '<li>'
                . Html::beginForm(['/site/logout'], 'post')
                . Html::submitButton(
                    'Logout (' . Yii::$app->user->identity->username . ')',
                    ['class' => 'btn btn-link logout']
                )
                . Html::endForm()
                . '</li>'
            ),
        ],
    ]);
    
    
    NavBar::end();
    ?>

    <div class="container">
        <?= Breadcrumbs::widget([
            'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
        ]) ?>
        <?= Alert::widget() ?>
        
        <?= $content ?>
    </div>
</div>

<footer class="footer">
    <div class="container">
        <p class="pull-left">&copy; Logi'ERP <?= date('Y') ?></p>

        <p class="pull-right"> Assuretec (T) Ltd </p>
    </div>
</footer>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
