<?php

use app\models\Accounts;
use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Exrate;
use app\models\Invoices;
use app\models\Invcontent;
use app\models\Invopayments;
use app\models\Clients;

/* @var $this yii\web\View */
/* @var $searchModel app\models\InvoicesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'All pending invoices';
$this->params['breadcrumbs'][] = $this->title;
?>



<div class="invoices-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
                                 
                                 
   <p align="right">
    <?= Html::a('New invoice', ['create'], ['class' => 'btn btn-success']) ?>
      </p>
      
       <div class="table-responsive">
                           <table class="table table-striped table-bordered table-hover">
                           
                           <thead>
                                 <tr>
                                    <th>
                                    <h4>Overdue</h4>
                                    <?php 
                                    $from='2018-01-01';
                                    $to=date('Y-m-d',strtotime('-30 days'));
                                    echo '( Tsh:'.number_format(Invoices::getTotalAmountOfInvoices($from,$to,0,1),2).')  ( ';
                                    echo 'Usd:'.number_format(Invoices::getTotalAmountOfInvoices($from,$to,0,2),2).' ) '; ?>
                                    
                                    
                                    </th>
                                    <th>
                                    <h4>Due on the next 30 days</h4>
                                    
                                     <?php 
                                    $from=date('Y-m-d',strtotime('-30 days'));
                                    $to=date('Y-m-d');
                                    echo '( Tsh:'.number_format(Invoices::getTotalAmountOfInvoices($from,$to,0,1),2).')  ( ';
                                    echo 'Usd:'.number_format(Invoices::getTotalAmountOfInvoices($from,$to,0,2),2).' ) '; ?>
                                    
                                    
                                    
                                    </th>
                                    </tr>
                           </thead>
                           </table>
                           </div>
      
      
      
              <?php 
Modal::begin([
    'options'=>[
        'tabindex' => false,
    ],
    'header'=>'',
    'id'=>'modal',
    'size'=>'modal-lg',
]);

echo '<div id="modalContent"></div>';

Modal::end();

?>


<?php 
/*
$invos=Invoices::find()->all();
echo 'No of invo '.count($invos).'<br>';
$cnt=0;
if ($invos != null){
    foreach ($invos as $invo){
        $nm=strtolower(Accounts::findOne($invo->accId)->name);
        $cls=Clients::find()->all();
        
        if($cls != null){
            foreach ($cls as $cl){
                if (stripos($nm,$cl->name)!== false){
                echo $cnt.' - '.$cl->name.' '.$invo->id.'<br>';
                $invo->clientId=$cl->id;
                $invo->save();
               break;
                }
            }
        }
        $cnt++;
    }
}

*/


$cls=Invoices::find()->all();
$c=1;
if ($cls != null){
    foreach ($cls as $cl){
        if ($cl->clientId==null){
            echo $c.' - '.$cl->id.'<br>';
            $c++;
        }
    }
}

?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            
                        [
                'attribute'=>'Type',
                'value'=>function ($model, $key, $index, $widget) {return Invoices::getInvoiceType($model->type).' '. Invoices::getInvoiceTax($model->tax); },
                'contentOptions' => function($model, $key, $index, $column){
                if ($model->type==1){
                    return ['style' =>'background-color:#197777; color:white;'];
                }elseif ($model->type==2){
                    return ['style' =>'background-color:#101CE0; color:white;']; 
                }elseif ($model->type==3){
                    return ['style' =>'background-color:#383FAF; color:white;']; 
                }
                },
            ],
            
           [
                'attribute'=>'clientId',
                'value'=>function ($model, $key, $index, $widget) {return $model->client->name; }
          
            ],
            [
                'attribute'=>'numbername',
                'value'=>function ($model, $key, $index, $widget) {return Invoices::getInvoiceNo(Invoices::findOne($model->id)->company,$model->id); }
            ],
            [
                'attribute'=>'date',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->date)); }
            ],

            [
                'attribute'=>'amount',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Invcontent::getInvoiceCost($model->id),2).' '.Accounts::getCurrency($model->currency); }
            ],
            [
                'attribute'=>'paida',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Invopayments::getInvoicePaidAmount($model->id)).' '.Accounts::getCurrency($model->currency); }
            ],
            
            [
                'attribute'=>'balance',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Invcontent::getInvoiceCost($model->id)-Invopayments::getInvoicePaidAmount($model->id),2).' '.Accounts::getCurrency($model->currency); }
            ],
            //'company',
            //'type',
            //'tax',
            //'currency',
   [
                            'class' => 'yii\grid\ActionColumn',
                            'contentOptions' => ['style' => 'width:60px;'],
                            'header'=>'Actions',
                            'template' => '{view}',
                            'buttons' => [
                                
                                //view button
                                'view' => function ($url, $model) {
                                
                                return  '<div class="dropdown">
                          <a class="glyphicon glyphicon-tasks" type="button" data-toggle="dropdown">
                          <span class="caret"></span></a>
                          <ul class="dropdown-menu">
                          <li>'.Html::a('update',['invoices/update','id'=>$model->id], ['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('download',['invcontent/printinvoice','id'=>$model->id], ['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('Create sub-invo',['invoices/createsub','id'=>$model->id], ['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('payment',['invopayments/create','id'=>$model->id], ['class' => 'glyphicon']).' </li>
                           <li>'.Html::a('Delete',['invoices/delete','id'=>$model->id], ['class' => 'glyphicon','data' => [
                              'confirm' => 'Are you sure you want to delete this item?',
                              'method' => 'post',
                          ]]).' </li>
                          </ul>
                        </div>';
                                
                                
                                },
                                ],
                                
                                ],
        ],
    ]); ?>
</div>