<?php

use app\models\Accounts;
use app\models\Services;
use kidzen\dynamicform\DynamicFormWidget;
use app\models\Clients;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;

/* @var $this yii\web\View */
/* @var $model app\models\Invoices */
/* @var $form yii\widgets\ActiveForm */
?>

<?php 
$liaAccounts = ArrayHelper:: map (Accounts::find()->where(['type'=>Accounts::getAccountsByCategory(1)])->all() , 'id' , function($model, $defaultValue){ return $model->name; }); 
$slines = ArrayHelper:: map (Clients::find()->where(['type'=>2])->all() , 'id' , 'name');
$clients = ArrayHelper:: map (Clients::find()->where(['type'=>1])->all() , 'id' , 'name');
$service = ArrayHelper:: map (Services::find()->where(['status'=>1])->all() , 'id' , function($mod, $defaultValue){ return $mod->name.'-'.Accounts::getCurrency($mod->currency); });
?>


<div class="invoices-form">

 <?php $form = ActiveForm::begin(['id' => 'dynamic-form']); ?>
    
    <table width="100%">
<tr>
        <td> 
               <?php 

echo $form->field($modelinvo, 'clientId')->widget(Select2::classname(), [
    'data' => $clients,
    'language' => 'en',
    'options' => ['placeholder' => 'Select client...'],
    'pluginOptions' => [
        'allowClear' => true,
        'tabindex' => false,
    ],
]);

?>
        
        <?= $form->field($modelinvo, 'type')->dropdownList([
        1 => 'Invoice', 
        2 => 'Profoma',
        3 => 'Debit note',
    ],
     [
         'style'=>'length:20px',
         'prompt'=>'-select-'
         
     ]
);?>


</td> 
<td>&nbsp;</td>
 <td> 
 
 <?= $form->field($modelinvo, 'currency')->dropdownList([
        1 => 'Tsh', 
        2 => 'Usd',
    ],
     [
         'style'=>'length:20px',
         'prompt'=>'-select-'
         
     ]
);?>
 
 
 
 <?= $form->field($modelinvo, 'tax')->dropdownList([
        0 => '0%', 
        1 => '18%',
    ],
     [
         'style'=>'length:20px',
         'prompt'=>'-select-'
         
     ]
);?>

 </td>
<td>&nbsp;</td>
<td>
 <?php 

echo $form->field($modelinvo, 'line')->widget(Select2::classname(), [
    'data' => $slines,
    'language' => 'en',
    'options' => ['placeholder' => 'Select a line...'],
    'pluginOptions' => [
        'allowClear' => true,
        'tabindex' => false,
    ],
]);

?>

<?= $form->field($modelinvo, 'description')->textarea(array('rows'=>2,'cols'=>5));?>

</td>

</tr>
</table>


        <div class="panel panel-default">
        <div class="panel-body">
       
             <?php DynamicFormWidget::begin([
                'widgetContainer' => 'dynamicform_wrapper', // required: only alphanumeric characters plus "_" [A-Za-z0-9_]
                'widgetBody' => '.container-items', // required: css class selector
                'widgetItem' => '.item', // required: css class
                'limit' => 10, // the maximum times, an element can be cloned (default 999)
                'min' => 1, // 0 or 1 (default 1)
                'insertButton' => '.add-item', // css class
                'deleteButton' => '.remove-item', // css class
                'model' => $modelinvocontent[0],
                'formId' => 'dynamic-form',
                'formFields' => [
                    'serviceId',
                    'count',
                    'date',
                    'amount',
                ],
            ]); ?>
            
            
            <div class="container-items"><!-- widgetContainer -->
            <?php foreach ($modelinvocontent as $i => $model): ?>
                <div class="item panel panel-default"><!-- widgetBody -->
                    <div class="panel-heading">
                        <div class="pull-right">
                            <button type="button" class="add-item btn btn-success btn-xs"><i class="glyphicon glyphicon-plus"></i></button>
                            <button type="button" class="remove-item btn btn-danger btn-xs"><i class="glyphicon glyphicon-minus"></i></button>
                        </div>
                        
                        
                        <div class="clearfix"></div>
                    </div>
                    <div class="panel-body">
                    
                        <?php
                            // necessary for update action.
                            if (! $model->isNewRecord) {
                                echo Html::activeHiddenInput($model, "[{$i}]id");
                            }
                        ?>
                          <table width="100%">
                        <tr><td>
                        
                             <?php 
   echo $form->field($model, "[{$i}]serviceId")->widget(Select2::classname(), [
         'data' => $service,
         'language' => 'en',
         'options' => [
             'placeholder' => 'Select service...',
             'class'=>'onchange-service',
             'data-url'=>\yii\helpers\Url::to(['get-price']),
         ],
         'pluginOptions' => [
             'allowClear' => true,
             'tabindex' => false,
         ],
         'pluginEvents' => [
             'change' => "function() {
                                                
             
                                                }",
         ]
     ]);
?>  </td>

<td>&nbsp;</td>
 <td>  <?= $form->field($model, "[{$i}]count")->textInput() ?>  </td><td>&nbsp;</td>

 <td> 
   <?php
   echo DatePicker::widget([
       'model' => $model,
       'attribute' => "[{$i}]date",
       'options' => ['placeholder' => 'Service date'],
       'pluginOptions' => [
           'format' => 'dd-M-yyyy',
           'todayHighlight' => true
       ]
   ]);
   
   ?></td>
<td>&nbsp;</td>
                      
                        <td> <?= $form->field($model, "[{$i}]amount")->textInput() ?> </td>
                      
                        
                         </tr> </table>
                    </div>
                </div>
            <?php endforeach; ?>
            
            <?php DynamicFormWidget::end(); ?>
    </div></div></div>
    


&nbsp;
<table width='30%'>

<tr>
<td>
    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>
    </td>
</tr>
</table>
    <?php ActiveForm::end(); ?>

</div>

