<?php

use app\models\Accounts;
use app\models\Invoices;
use app\models\Packages;
use app\models\Services;
use yii\grid\GridView;
use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model app\models\Invcontent */

$this->title = 'Update invoice';
$this->params['breadcrumbs'][] = ['label' => 'Invoice', 'url' => ['invoices/index']];
$this->params['breadcrumbs'][] = 'Update';
?>
<div class="invcontent-update">

    <h3 align="center"><?= Html::encode($this->title) ?></h3>
    
    <h4>Invoice to:<?php echo Invoices::findOne($model->invId)->acc->name; ?> </br> Currency: <?php echo Accounts::getCurrency(Invoices::findOne($model->invId)->currency); ?> </br>  Invoice #: <?php echo Invoices::getInvoiceNo(Invoices::findOne($model->invId)->company,$model->invId); ?></br>Date: <?php echo date('d-m-Y',strtotime(Invoices::findOne($model->invId)->date));?> </h4>
    
    
    &nbsp;&nbsp;
    
 <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'serviceId',
                'value'=>function ($model, $key, $index, $widget) {return Services::findOne($model->serviceId)->name.Packages::getContNumber($model->id).'-'.Accounts::getCurrency(Services::findOne($model->serviceId)->currency); }
            ],
            
            [
                'attribute'=>'date',
                'value'=>function ($model, $key, $index, $widget) {return date('M',strtotime($model->date)); }
            ],
            
            [
                'attribute'=>'amount',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->amount); }
            ],
            
            [
                'attribute'=>'count',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->count).Packages::getBarelNumber($model->id); }
            ],
            
            [
                'attribute'=>'subtotal',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->count*$model->amount); }
            ],
            
            [
                'attribute'=>'tax',
                'value'=>function ($model, $key, $index, $widget) {return Invoices::findOne($model->invId)->tax==1?number_format($model->count*$model->amount*0.18):0; }
            ],
            
            [
                'attribute'=>'total',
                'value'=>function ($model, $key, $index, $widget) {return Invoices::findOne($model->invId)->tax==1?number_format(($model->count*$model->amount)+($model->count*$model->amount*0.18)):number_format($model->count*$model->amount); }
            ],
            
            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{update}'
            ],

            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{delete}'
            ],
        ],
    ]); ?>
    

    <?= $this->render('_formold', [
        'model' => $model,'id'=>$model->invId
    ]) ?>

</div>
