<?php

use yii\grid\GridView;
use yii\helpers\Html;
use app\models\Accounts;
use app\models\Invoices;
use app\models\Services;
use app\models\Packages;

/* @var $this yii\web\View */
/* @var $model app\models\Invcontent */

$this->title = Invoices::getInvoiceType(Invoices::findOne($id)->type);
$this->params['breadcrumbs'][] = ['label' => 'Invoices', 'url' => ['invoices/index']];
$this->params['breadcrumbs'][] = $this->title;
?>


<?php 



?>
<div class="invcontent-create">

    <h3  align="center"><?= Html::encode($this->title) ?></h3>
    
        <p>
        <?= Html::a('', ['invcontent/printinvoice','id'=>$id], ['class' => 'glyphicon glyphicon-download-alt pull-right']) ?>
        
         <?= Html::a('', ['invoices/createsub','id'=>$id], ['class' => 'glyphicon glyphicon-open pull-center']) ?>
    </p>


<h4>Invoice to:<?php echo Invoices::findOne($id)->client->name; ?> </br> Currency: <?php echo Accounts::getCurrency(Invoices::findOne($id)->currency); ?> </br>  Invoice #: <?php echo Invoices::getInvoiceNo(Invoices::findOne($id)->company,$id); ?></br>Date: <?php echo date('d-m-Y',strtotime(Invoices::findOne($id)->date));?> </h4>

 <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'serviceId',
                'value'=>function ($model, $key, $index, $widget) {return Services::findOne($model->serviceId)->name.Packages::getContNumber($model->id).'-'.Accounts::getCurrency(Services::findOne($model->serviceId)->currency); }
            ],
            
            [
                'attribute'=>'date',
                'value'=>function ($model, $key, $index, $widget) {return date('M',strtotime($model->date)); }
            ],
            
            [
                'attribute'=>'amount',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->amount); }
            ],
            
            [
                'attribute'=>'count',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->count).Packages::getBarelNumber($model->id); }
            ],
            
            [
                'attribute'=>'subtotal',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->count*$model->amount); }
            ],
            
            [
                'attribute'=>'tax',
                'value'=>function ($model, $key, $index, $widget) {return Invoices::findOne($model->invId)->tax==1?number_format($model->count*$model->amount*0.18):0; }
            ],
            
            [
                'attribute'=>'total',
                'value'=>function ($model, $key, $index, $widget) {return Invoices::findOne($model->invId)->tax==1?number_format(($model->count*$model->amount)+($model->count*$model->amount*0.18)):number_format($model->count*$model->amount); }
            ],
            
              ['class' => 'yii\grid\ActionColumn',
                'template'=>'{update}'
            ],

            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{delete}'
            ],
        ],
    ]); ?>

<?php if (Invoices::findOne($id)->lok==0){?>

<?php if (Invoices::findOne($id)->fileId==0) { ?>

    <?= $this->render('_form', [
        'models' => $models,'id'=>$id
    ]) ?>
    
<?php } else{ ?>
    
        <?= $this->render('_cnform', [
            'models' => $models,'id'=>$id,
    ]) ?>
    
<?php } }else { ?>

 <p><?= Html::a('', ['invoices/unlock','id'=>$id], ['class' => 'glyphicon glyphicon-check']) ?>
        Invoice locked 
</p>

<?php } ?>
</div>