<?php

use yii\helpers\Html;
use app\models\Fuelrequest;
use app\models\Offuels;
use app\models\Movements;

/* @var $this yii\web\View */
/* @var $model app\models\Fuelrequest */

$this->title = 'As refunded ('.$truckId.')';
$this->params['breadcrumbs'][] = ['label' => 'Car select', 'url' => ['carselect']];
$this->params['breadcrumbs'][] = $this->title;
?>

<h3>Active fuel status (<?php echo $truckId; ?>)</h3>


<table class="table table-striped table-bordered table-hover">
  <tr>
    <th>Fuel filled at</th>
    <th>Filled(Lts)</th>
    <th>Full trips(Lts)</th>
    <th>Empty trips(Lts)</th>
    <th>Other trips(Lts)</th>
     <th>Off Operations(Lts)</th>
    <th>Remain(Lts)</th>
    <th></th>
  </tr>
  <?php 
  $fuels=Fuelrequest::find()->where(['status'=>1,'truckId'=>$truckId])->all();

  if ($fuels != null){
      foreach ($fuels as $fuel){
          ?>

  <tr>
    <td><?php echo date('d-M-Y',strtotime($fuel->fueldate)); ?></td>
    <td><?php echo $fuel->volume; ?></td>
    <td><?php echo $f=Fuelrequest::getConsumedFuelByFull($fuel->id); ?></td>
    <td><?php echo $e=Fuelrequest::getConsumedFuelByEmpty($fuel->id); ?></td>
    <td><?php echo $o=Fuelrequest::getConsumedFuelByOther($fuel->id); ?></td>
    <td><?php echo $of=Offuels::getConsumedfuels($fuel->id); ?></td>
    <?php $remainedFuel=($fuel->volume-($f+$o+$e+$of));?>
    <td><?php echo $remainedFuel; ?></td>
    <td>
    <?php  if($remainedFuel==$fuel->volume) echo Html::a('', ['update','id'=>$fuel->id], ['class' => 'glyphicon glyphicon-pencil']) ?>
    <?php  if($remainedFuel<=9) echo Html::a('', ['deactivatefuel','id'=>$fuel->id], ['class' => 'glyphicon glyphicon-log-out']) ?>
    <?php  echo Html::a('', ['offuels/create','id'=>$fuel->id,'remain'=>$remainedFuel,'tk'=>$truckId], ['class' => 'glyphicon glyphicon-save-file']) ?>
    </td>
  </tr>
  
  <?php
        }
  }else{
  ?>
  <tr><td>No active fuels</td><td></td><td></td><td></td><td></td><td></td><td></td></tr>
  <?php } ?>
</table>

<h3>Movement informations</h3>

<table class="table table-striped table-bordered table-hover">
  <tr>
    <th>Truck</th>
    <th>Line</th>
    <th>Cont #</th>
    <th>Movement</th>
    <th>Date</th>
     <th>Size</th>
    <th>Client</th>
    <th>Driver</th>
  </tr>
  
   <tr>
    <th><?php echo $model->truckId; ?></th>
    <th><?php echo $model->shippingline0->name; ?></th>
    <th><?php echo $model->containerno; ?></th>
    <th><?php echo $model->movetype->name; ?></th>
    <th><?php echo date('d-M-Y',strtotime($model->interchangedate)); ?></th>
     <th><?php echo $model->size.'0ft'; ?></th>
    <th><?php echo $model->client->name; ?></th>
    <th><?php echo $model->driver->user->fullName; ?></th>
  </tr>
  
  </table>


  <p align="right">
        <?= Html::a('Save as reserve', ['/fuelrequest/viewcar'
            ,'truckId'=>$model->truckId,'move'=>$model->movetypeId,
            'date'=>$model->interchangedate,'driver'=>$model->driverId,'cont'=>$model->containerno,
            'line'=>$model->shippingline,'size'=>$model->size,'clie'=>$model->clientId,'stat'=>1
        ], ['class' => 'btn btn-success']) ?>
    </p>
