<?php

use yii\helpers\Html;
use yii\grid\GridView;
use app\models\Fromclients;
use app\models\Cars;

/* @var $this yii\web\View */
/* @var $searchModel app\models\FromclientsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'List of containers to use from clients';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="fromclients-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    

    <p align='right'>
        <?= Html::a('Upload new', ['create'], ['class' => 'btn btn-success']) ?>
    </p>


    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

             [
                'attribute'=>'contno',
                'value'=>function ($model, $key, $index, $widget) {return  Fromclients::checkcontainer($model->id); }
            ],
            'truckno',
            [
                'attribute'=>'date',
                'value'=>function ($model, $key, $index, $widget) {return  date('d-M-Y',strtotime(date($model->date))); }
            ],
        ],
    ]); ?>
</div>
