<?php

use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\models\Dispatchcontents;
use app\models\Wstore;
use app\models\Services;
use kartik\select2\Select2;

/* @var $this yii\web\View */
/* @var $model app\models\Dispatchcontents */
/* @var $form yii\widgets\ActiveForm */
?>

<?php 
$storeServices = ArrayHelper:: map (Wstore::find()->where(['status'=>1])-> all() , 'id' , function($model, $defaultValue){ return Services::findOne($model->serviceId)->name.' ('.Dispatchcontents::getStoreBalance($model->id).')'; });
?>

<div class="dispatchcontents-form">

     <?php $form = ActiveForm::begin([
        'fieldConfig' => [
            'template' => " <div class='row'><div class='col-xs-11'>{label}{input}{error}{hint}</div></div>",
        ],
    ]); ?>
    
<table width="100%">
<tr>
   <td>
     <?php 

echo $form->field($model, 'storeId')->widget(Select2::classname(), [
    'data' => $storeServices,
    'language' => 'en',
    'options' => ['placeholder' => 'Select services...'],
    'pluginOptions' => [
        'allowClear' => true,
        'tabindex' => false,
    ],
]);

?>
   </td>

    <td><?= $form->field($model, 'quantity')->textInput() ?></td>
</tr>

<tr>
<td>
    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>
  </td>
  <td></td>
</tr>

</table>
    <?php ActiveForm::end(); ?>

</div>
