<?php

use app\models\Billcontent;
use app\models\Bills;
use app\models\Defectivetrucks;
use yii\bootstrap\Modal;
use yii\helpers\Html;
use yii\widgets\DetailView;
use app\models\Techassign;
use app\models\Rfqcontent;
use app\models\Cardrivers;

/* @var $this yii\web\View */
/* @var $model app\models\Defectivetrucks */

$this->title = 'Car workshop status';
$this->params['breadcrumbs'][] = ['label' => 'Defectivetrucks', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="defectivetrucks-view">

   

    <p align="right">
    <?= Html::a('Job card paper', ['printjobcard', 'id' => $model->id], ['class' => 'btn btn-info']) ?>
        <?= Html::a('Gateout paper', ['printrelease', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
  <?php if($model->outdate=='0000-00-00')  { ?>
         <?= Html::a('Release',['release', 'id' => $model->id],['class' => 'btn btn-success']) ?>
    <?php }if((Yii::$app->user->can('Admin'))){ ?>
     <?php if($model->status !=1) { ?>
     <?= Html::a('On maintanance',['changestatus', 'id' => $model->id,'status'=>1],['class' => 'btn btn-warning']) ?>
     <?php } ?>
    <?php if($model->status !=2) { ?>
     <?= Html::a('Completed',['completed', 'id' => $model->id],['class' => 'btn btn-danger']) ?>
     <?php } ?>
      <?php if($model->status !=3) { ?>
     <?= Html::a('Complicated',['changestatus', 'id' => $model->id,'status'=>3],['class' => 'btn btn-warning']) ?>
     <?php } ?>
         <?php if($model->status !=0) { ?>
     <?= Html::a('Pending',['changestatus', 'id' => $model->id,'status'=>0],['class' => 'btn btn-info']) ?>
     <?php } ?>     
       
     
    <?php }?>
    
    </p>
    
     <h3><?= Html::encode($this->title) ?></h3>
    <p align="right"><?= Html::a('Update',['update', 'id' =>$model->id]) ?> </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            [
                'attribute'=>'carId',
                'value'=>$model->carId.'-'.strtolower($model->car->type->name),
            ],
            [
                'attribute'=>'status',
                'value'=>Defectivetrucks::getStatusValue($model->status),
            ],
            'reason',
            [
                'attribute'=>'indate',
                'value'=>date('d-m-Y',strtotime($model->indate)),
            ],
            
            [
                'attribute'=>'expected',
                'value'=>date('d-m-Y',strtotime($model->expected)),
            ],
            
            [
                'attribute'=>'outdate',
                'value'=>$model->outdate=='0000-00-00'?'Still in':date('d-m-Y',strtotime($model->outdate)),
            ],
        ],
    ]) ?>

</div>

<table class="table">

<tr><td>

<h4>Assigned technicians </h4>

     <?php 
        Modal::begin([
            'options'=>[
                'tabindex' => false,
            ],
            'header'=>'',
            'id'=>'modal',
            'size'=>'modal-lg',
        ]);
        
        echo '<div id="modalContent"></div>';
        
        Modal::end();

?>

 <table class="table table-striped table-bordered table-hover">
                              <thead> <tr><th>#</th><th>Technician</th>
                              <th>
                               <?= Html::button('Assign',['value'=>\yii\helpers\Url::toRoute(['/techassign/create','dId'=>$id]),'id'=>'modalButton'])?>
                              </th></tr></thead>
                              <?php 
                              $techs= Techassign::find()->where(['defectiveId'=>$id])->all();
                              $cnt=1;
                              if ($techs != null){ foreach ($techs as $tech){
                              ?>
                              <tbody><tr><td><?php echo $cnt; ?></td><td><?php echo $tech->user->fullName; ?></td>
                              <td>
                               <?= Html::a('', ['techassign/delete', 'id' => $tech->id], [
                                    'class' => 'glyphicon glyphicon-remove',
                                    'data' => [
                                        'confirm' => 'Are you sure you want to delete this item?',
                                        'method' => 'post',
                                    ],
                                ]) ?>
                              
                              
                              </td>
                              
                              </tr></tbody>
                              
                              <?php $cnt++; } }  ?>
                              
 </table>
                         
                              
</td><td>



<h4>Requested spares</h4>

 <table class="table table-striped table-bordered table-hover">
                              <thead> <tr><th>#</th><th>Spare</th><th>Quantity</th><th>Status</th><th></th></tr></thead>
                              <?php 
                              $from=$model->indate;
                              $to=date('Y-m-d');
                              $spares= Rfqcontent::find()->where("date >= '$from' and date <= '$to' and carId=:carid and status=:st",[':carid'=>$model->carId,'st'=>1])->all();
                             
                              $cc=1;
                              if ($spares != null) {
                                  foreach ($spares as $spare){  ?>
                                     
                                              <tbody><tr><td><?php echo $cc; ?></td><td><?php echo $spare->service->name.' ('.date('d-M',strtotime($spare->date)).')'; ?></td><td><?php echo $spare->count; ?>
                                             </td><td><?php echo 'Pending'; ?></td>
                                             <td> <?= Html::a('',['rfqcontent/suppliedview', 'id' => $spare->id,'df'=>$model->id],['class' => 'glyphicon glyphicon-ok']) ?></td>
                                             </tr></tbody>
                              
                              						<?php 
                                              $cc++;    
                                  }
                              }
                              
                              $spares2= Rfqcontent::find()->where("date >= '$from' and date <= '$to' and carId=:carid and status=:st",[':carid'=>$model->carId,'st'=>0])->all();
                              
                             
                              if ($spares2 != null) {
                                  foreach ($spares2 as $spare){  ?>
                                     
                                              <tbody><tr><td><?php echo $cc; ?></td><td><?php echo $spare->service->name.' ('.date('d-M',strtotime($spare->date)).')'; ?></td><td><?php echo $spare->count; ?>
                                             </td><td><?php echo 'Supplied'; ?></td><td></td>
                                             </tr></tbody>
                              
                              						<?php 
                                              $cc++;    
                                  }
                              }
                              
                              ?>
                              
 </table>

 


</td><td>                           
  
<h4>Assigned spares</h4>

 <table class="table table-striped table-bordered table-hover">
                              <thead> <tr><th>#</th><th>Spare</th><th>Quantity</th></tr></thead>
                              <?php 
                              $spares= Defectivetrucks::getTruckcontent($model->carId,$model->indate);
                              if ($spares != null){ for ($i=0; $i<count($spares); $i++) {
                              ?>
                              <tbody><tr><td><?php echo $i+1; ?></td><td><?php echo $spares[$i]['spare']; ?></td><td><?php echo $spares[$i]['quantity']; ?></td></tr></tbody>
                              
                              <?php } }  ?>
                              
 </table>
 
 </td></tr>
 
 <tr>
     <tr><th></th><th>Drivers</th><th></th></tr>
     <td></td>
     <td>
           <?php
  $c=1;
  $drivers=Cardrivers::getActiveDriver($model->carId);
 if($drivers != null){
     foreach ($drivers as $driver){
         if ($driver->user->company==\Yii::$app->session->get('company') and $driver->user->status==1){
             if(count(Cardrivers::find()->where(['userId'=>$driver->userId, 'status'=>1])->orderBy(['dateassigned'=>SORT_ASC])->all()) < 3){
             echo $c.'. '. $driver->user->firstname.' '.$driver->user->lastname.' ('.$driver->user->mobilephone.')'.'<br />'; 
                $c++;
             }
         }
     } } ?>
         
     </td><td></td>
     
 </tr>
 
 </table>
                              
                              
                              
                              
                              
                              
                              
