<?php

use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Defectivetrucks;

/* @var $this yii\web\View */
/* @var $searchModel app\models\DefectivetrucksSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Defective trucks';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="defectivetrucks-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
    
     <p align="right">
         <?= Html::button('New defect',['value'=>\yii\helpers\Url::toRoute('create'),'class' => 'btn btn-success','id'=>'modalButton']) ?>
    </p>
    
     <?php 
        Modal::begin([
            'options'=>[
                'tabindex' => false,
            ],
            'header'=>'',
            'id'=>'modal',
            'size'=>'modal-lg',
        ]);
        
        echo '<div id="modalContent"></div>';
        
        Modal::end();

?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            [
                'attribute'=>'carId',
                'value'=>function ($model, $key, $index, $widget) {return $model->carId.'-'.strtolower($model->car->type->name); }
            ],
            
                        [
                'attribute'=>'status',
                'value'=>function ($model, $key, $index, $widget) {return Defectivetrucks::getStatusValue($model->status); },
                'contentOptions' => function($model, $key, $index, $column){
                if ($model->status==0){
                    return ['style' =>'background-color:#41073A; color:white;'];
                }elseif ($model->status==1){
                    return ['style' =>'background-color:#101CE0; color:white;'];
                }elseif ($model->status==2){
                    return ['style' =>'background-color:#006400; color:white;'];
                }elseif ($model->status==3){
                        return ['style' =>'background-color:#FF0000; color:white;'];
                    }
                },
                ],
            
            'reason',
            [
                    'attribute'=>'indate',
                    'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->indate)); }
                ],
                
                 [
                    'attribute'=>'expected',
                    'value'=>function ($model, $key, $index, $widget) {return date('d-m',strtotime($model->expected)); }
                ],
                
                        
                        ['class' => 'yii\grid\ActionColumn',
                            'template'=>'{view}',
                        ],
        ],
    ]); ?>
</div>