<?php

use yii\helpers\Html;
use yii\grid\GridView;
use app\models\Cfile;

/* @var $this yii\web\View */
/* @var $searchModel app\models\CfileSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'All active files';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="cfile-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p align="right">
        <?= Html::a('New file', ['precreate'], ['class' => 'btn btn-success']) ?>
    </p>
    
    
        <?php 
    $cfiles= Cfile::find()->all();
    
    if ($cfiles != null){
        foreach ($cfiles as $file){
            $age=Cfile::getFileExpirationStatus($file->onn);
            
            if ($age > 4){
                $file->fstatus=0;
                $file->save();
            }
        }
    }
    
    ?>
    

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'blnumber',
            [
                'attribute'=>'ftype',
                'value'=>function ($model, $key, $index, $widget) {return $model->ftype==1?'IMPORT':'EXPORT'; }
            ],
            
            [
                'attribute'=>'age(M)',
                'value'=>function ($model, $key, $index, $widget) {return Cfile::getFileExpirationStatus($model->onn); }
            ],
            [
                'attribute'=>'delivery',
                'value'=>function ($model, $key, $index, $widget) {return $model->delivery==1?"YES":"NO"; }
            ],
            [
                'attribute'=>'dangestatus',
                'value'=>function ($model, $key, $index, $widget) {return $model->dangestatus==1?"YES":"NO"; }
            ],
                        [
                'class' => 'yii\grid\ActionColumn',
                'contentOptions' => ['style' => 'width:60px;'],
                'header'=>'Actions',
                'template' => '{view}',
                'buttons' => [
                    
                    //view button
                    'view' => function ($url, $model) {
                    
                    return  '<div class="dropdown">
                          <a class="glyphicon glyphicon-tasks" type="button" data-toggle="dropdown">
                          <span class="caret"></span></a>
                          <ul class="dropdown-menu">
                          <li>'.Html::a('Go to file',['docsupload/index','id'=>$model->id]).' </li>
                          <li>'.Html::a('Updates',['cfile/update','id'=>$model->id]).' </li>
                          <li>'.Html::a('Delete',['docsuploa/delete','id'=>$model->id]).' </li>
                          </ul>
                        </div>';
                    
                    
                    },
                    ],
                    
                    ],
        ],
    ]); ?>
</div>