<?php

use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\models\Clients;
use kartik\select2\Select2;
use kartik\date\DatePicker;

/* @var $this yii\web\View */
/* @var $model app\models\Cfile */
/* @var $form yii\widgets\ActiveForm */
?>

<?php $clients = ArrayHelper:: map (Clients::find()->where(['type'=>1])->all() , 'id' , function($model, $defaultValue){ return $model->name; }); ?>



<div class="cfile-form">

   <?php $form = ActiveForm::begin([
        'fieldConfig' => [
            'template' => " <div class='row'><div class='col-xs-11'>{label}{input}{error}{hint}</div></div>",
        ],
    ]); ?>
    
          <div class="panel panel-default">
               <div class="panel-heading">SET ACTUAL TIME OF BIRTH</div>
               <div class="panel-body">
    
    <table width="100%">
<tr>
        <td>
        <?php 
        echo DatePicker::widget([
            'model' => $model,
            'attribute' => 'atb', 
            'options' => ['placeholder' => 'Actual time of Birth'],
            'pluginOptions' => [
                'format' => 'dd-M-yyyy',
                'todayHighlight' => true
            ]
        ]);
        
        ?>
		</td>
        <td>&nbsp;</td>
       <td>
    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>
    </td>
    </tr></table>

    <?php ActiveForm::end(); ?>

</div>
