<?php

use app\models\Accounts;
use app\models\Billcontent;
use app\models\Cfile;
use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Billpayments;
use app\models\Bills;

/* @var $this yii\web\View */
/* @var $searchModel app\models\WshopbillsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Bl #'.Cfile::findOne(\Yii::$app->session->get('fileId'))->blnumber.' requests';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wshopbills-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

          <p align="right">
        <?= Html::a('New request', ['bills/createclearing'], ['class' => 'btn btn-success']) ?>
      </p>
      
<?php 
        Modal::begin([
            'options'=>[
                'tabindex' => false,
            ],
            'header'=>'',
            'id'=>'modal',
            'size'=>'modal-lg',
        ]);
        
        echo '<div id="modalContent"></div>';
        
        Modal::end();

?>
      

  <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            
                        [
                'attribute'=>'Status',
                'value'=>function ($model, $key, $index, $widget) {return Billpayments::getPaidByBill($model->billId)==0?'Pending':'Paid'; },
                'contentOptions' => function($model, $key, $index, $column){
                if (Billpayments::getPaidByBill($model->billId)>0){
                    return ['style' =>'background-color:#197777; color:white;'];
                }elseif (Billpayments::getPaidByBill($model->billId)==0){
                    return ['style' =>'background-color:#101CE0; color:white;'];
                }
                },
                ],
            
             [
                    'attribute'=>'billId',
                    'value'=>function ($model, $key, $index, $widget) {return Bills::getBillNo(Bills::findOne($model->billId)->company,$model->billId); }
                ],
            
            [
                'attribute'=>'client',
                'value'=>function ($model, $key, $index, $widget) {return $model->bill->client->name; }
            ],
            [
                'attribute'=>'date',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->bill->date)); }
            ],
            [
                'attribute'=>'dueDate',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->bill->dueDate)); }
            ],
            [
                'attribute'=>'billamount',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Billcontent::getBillCost($model->billId),2).'-'.Accounts::getCurrency($model->bill->currency); }
            ],
             
            [
                'attribute'=>'paidamount',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Billpayments::getPaidByBill($model->billId),2).' '.Accounts::getCurrency($model->bill->currency); }
            ],
            
            //'paid',
            //'company',
            //'currency',
            
            [
                'class' => 'yii\grid\ActionColumn',
                'contentOptions' => ['style' => 'width:60px;'],
                'header'=>'Actions',
                'template' => '{view}',
                'buttons' => [
                    
                    //view button
                    'view' => function ($url, $model) {
                    
                    return  '<div class="dropdown">
                          <a class="glyphicon glyphicon-tasks" type="button" data-toggle="dropdown">
                          <span class="caret"></span></a>
                          <ul class="dropdown-menu">
                          <li>'.Html::a('Update',['bills/update','id'=>$model->billId], ['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('Download',['billcontent/printrequest','id'=>$model->billId], ['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('Record payment',['billpayments/create','id'=>$model->billId], ['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('Delete',['bills/delete','id'=>$model->billId], ['class' => 'glyphicon']).' </li>
                          </ul>
                        </div>';
                    
                    
                    },
                    ],
                    
                    ],
            
        ],
    ]); ?>
</div>
