<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use app\models\Movetype;
use app\models\Movefuelratio;

/* @var $this yii\web\View */
/* @var $model app\models\Cartype */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => 'Cartypes', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="cartype-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'name',
            'model',
        ],
    ]) ?>
    
    <?php 
    
    $allmoves= Movetype::find()->all();
    
    if($allmoves != null){
        foreach($allmoves as $move){
            $ratio= Movefuelratio::findOne(['cartypeId'=>9,'movetypeId'=>$move->id])->moveconsumption;
            if($model->id==16){
            $new=new Movefuelratio();
            $new->cartypeId=16;
            $new->movetypeId=$move->id;
            $new->moveconsumption=$ratio;
            
           /* if($new->save()){
            echo $move->name.' - '.$ratio.' <br />';
            } */
            
            }
        }
    }
    
    
    ?>

</div>
