<?php

use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Cartype;

/* @var $this yii\web\View */
/* @var $searchModel app\models\CartypeSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'All car models';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="cartype-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

     <p align="right">
        <?= Html::button('New model',['value'=>\yii\helpers\Url::toRoute('create'),'class' => 'btn btn-success','id'=>'modalButton']) ?>
        <?= Html::a('Car brands', ['carmodel/index'], ['class' => 'btn btn-success']) ?>
    </p>
    
       <?php 
    Modal::begin([
       'header'=>'<h4></h4>',
        'id'=>'modal',
        'size'=>'modal-lg',
    ]);
    
    echo '<div id="modalContent"></div>';
    
    Modal::end();
    
    ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'name',
            'model',
            [
                'attribute'=>'numbers',
                'value'=>function ($model, $key, $index, $widget) {
                return Cartype::getNumberOfCars($model->id);
                },
                ],

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
