<?php

use app\models\Uzers;
use yii\bootstrap\Modal;
use yii\helpers\Html;
use yii\widgets\DetailView;
use app\models\Fuelrequest;
use app\models\Movements;
use app\models\Tireallocation;
use app\models\Trailers;
use app\models\Cardrivers;
use app\models\Wstoredispatch;
use app\models\Trafficoffences;
use app\models\Defectivetrucks;
use app\models\Bills;
use app\models\Cars;

/* @var $this yii\web\View */
/* @var $model app\models\Cars */

$this->title = $model->plateno;
$this->params['breadcrumbs'][] = ['label' => 'Cars', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="cars-view">

 

<table width="100%">
<tr>
<td style ="border-bottom:1px solid black;"><h4>HORSE: <?php echo mb_strtoupper($model->plateno); ?></h4></td>
<td style ="border-bottom:1px solid black;"><h4>TRAILER: <?php echo mb_strtoupper(Trailers::getActiveTrailer($model->plateno)); ?> </h4></td>
<td style ="border-bottom:1px solid black;">
<?php if (mb_strtolower($model->type->name) != 'trailer'){ ?>
<?= Html::button('Set trailer & driver',['value'=>\yii\helpers\Url::toRoute(['cardrivers/create','id'=>$model->plateno]),'class' => 'btn btn-success','id'=>'modalButton']) ?>
<?php } ?>
</td>
</tr>
</table>

    
    &nbsp;


     <?php 
    
     Modal::begin([
         'options'=>[
             'tabindex' => false,
         ],
         'header'=>'',
         'id'=>'modal',
         'size'=>'modal-lg',
     ]);
     
     echo '<div id="modalContent"></div>';
     
     Modal::end();
    
    ?>

 <table class="table table-bordered table-hover"><tr><td>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            [
                'attribute'=>'typeId',
                'value'=>$model->type->name.'-'.$model->type->model,
                ],
       
            
            [
                'attribute'=>'status',
                'value'=> Uzers::getStatus($model->status),
            ],
            
             [
                'attribute'=>'capacity',
                'value'=> Cars::getcarcapacity($model->capacity),
            ],
            
            [
                'attribute'=>'datepurchased',
                'value'=>date('d-M-Y',strtotime($model->datepurchased)),
            ],
        ],
    ]) ?>

</td>

  <td>
  DRIVERS <br />
  <?php
  $c=1;
  $drivers=Cardrivers::getActiveDriver($model->plateno);
 if($drivers != null){
     foreach ($drivers as $driver){
         if ($driver->user->company==\Yii::$app->session->get('company')){
             echo $c.'. '. $driver->user->firstname.' '.$driver->user->lastname.
             Html::a(' ', ['/cardrivers/unsetonedriver','id'=>$driver->user->id,'car'=>$model->plateno], ['class' => 'pull-right glyphicon glyphicon-remove']).'<br />'; 
                $c++;
         }
     } } ?>
  </td>

  </tr>
  </table>


</div>

<?php 
//$f=date('Y-m-d',strtotime('-2years'));
$f='2022-01-01';
$t=date('Y-m-d');
$totalcost=0;
?>

<table class="table table-striped table-bordered table-hover">
  <tr>
    <th>Workshop records   <?= Html::a('print', ['/wstoredispatch/reportbycardirect','id'=>$model->plateno,'f'=>$f,'t'=>$t,
        ], ['class' => 'pull-right']) ?></th>
    <th>Road offences</th>
    <th>Fuel records</th>
    <th>Movements</th>
  </tr>
  <tr>
  <td>
  <table class="table table-bordered table-hover"><tr>
  <td>Frequency in wshop</td><td><?php echo count(Defectivetrucks::checkCarAvailability($model->plateno,$f,$t));?></td>
  </tr>
  <tr>
  <td>Cost spent</td><td><?php
  $wcost= Bills::getCarCostByTime($f,$t,$model->plateno);
  $totalcost=$totalcost+$wcost;
  echo number_format($wcost,2); ?> Tsh</td>
  </tr>
  </table>
  
  </td>
  
  <td>Cost spent: <?php 
  $ocost=Trafficoffences::calculateCarCost($model->plateno,$f,$t);
  $totalcost=$totalcost+$ocost;
  echo number_format($ocost,2); ?> Tsh</td>
  
  <td>
  
   <table class="table table-bordered table-hover"><tr>
  <td>Volume used:</td><td>
  <?php  echo number_format(Fuelrequest::getTruckFueledAmountByTime($model->plateno,$f,$t));  ?> lts
  </td>
  </tr>
  <tr>
  <td>Cost spent:</td><td>
    <?php  
    $fcost=Fuelrequest::getTruckConsumedfuelByTimeCost($model->plateno,$f,$t);
    $totalcost=$totalcost+$fcost;
    echo number_format($fcost,2); ?> Tsh
  
  </td>
  </tr>
  </table>
  
  </td>
  
  <td>No of Moves: <?php echo Movements::carMovementsByTime($model->plateno,$f,$t); ?></td>
  
  </tr>
  
  </table>
  
  <b>Total Cost: </b><?php echo number_format($totalcost,2); ?> Tsh
  
  
  
  <h4> Tire managements ( <?php echo $model->plateno;  ?>) </h4>
  <?= Html::a('Print', ['/tireallocation/trucktires','truckId'=>$model->plateno], ['class' => 'pull-left']) ?>
  <table class="table table-striped table-bordered table-hover">
  <tr>
    <th>BrandNw</th>
     <th>Retread</th>
     <th>Good</th>
     <th>Intermidiate</th>
    <th>Wareout</th>
    <th>Changed</th>
    <th></th>
  </tr>
  <tr>
  
    <?php 
  $bn=0; $rt=0; $go=0; $in=0; $wr=0; $ch=0;
  
  $tires=Tireallocation::find()
  ->where(['carId'=>$model->plateno])->orderBy(['date'=>SORT_DESC])->all();
  
  if ($tires != null){
      foreach ($tires as $tire){
           if ($tire->store->category==1){ $bn++; }
          elseif ($tire->store->category==2) { $rt++; }
          elseif ($tire->store->category==3) { $go++; }
          elseif ($tire->store->category==4) { $in++; }
          elseif ($tire->store->category==5) { $wr++; }
          elseif ($tire->store->category==0)  { $ch++; }
   
      } }
          ?>
          
  <td><?php echo $bn; ?> </td>
  <td> <?php  echo $rt;  ?> </td>
  <td><?php  echo $go;  ?></td>
  <td><?php  echo $in;  ?></td>
   <td><?php  echo $wr;  ?></td>
    <td><?php  echo $ch;  ?></td>
    <td> <?= Html::a('View', ['/tireallocation/create','id'=>$model->plateno], ['class' => 'pull-right']) ?></td>
  <?php 
      ?>
  </tr>
  </table>

