<?php

use yii\helpers\Html;
use yii\grid\GridView;
use app\models\Cartype;
use app\models\Trucks;
use SebastianBergmann\CodeCoverage\Report\PHP;
use app\models\Uzers;
use yii\bootstrap\Modal;
use PharIo\Manifest\Url;
use PHPUnit\Framework\Constraint\Count;
use app\models\Cars;
use app\models\Carmodel;

/* @var $this yii\web\View */
/* @var $searchModel app\models\CarsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title ='All cars';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="cars-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
  
    <p align="right">
        <?= Html::a('New car', ['create'], ['class' => 'btn btn-success']) ?>
    </p>
   
    
    
    <table class="table table-striped table-bordered table-hover">
<tr>
<?php 
$mods= Carmodel::find()->all();
$total=0;
if ($mods!=null){
    foreach ($mods as $mod){  if (Cars::getTypequantity($mod->id)>0) { ?>
        <td><?php 
        echo strtoupper($mod->name).' ('. Cars::getTypequantity($mod->id).')';
        $total=$total + Cars::getTypequantity($mod->id);
        ?></td>
 <?php } }
}
?>
</tr>
</table>



    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'plateno',
            [
                'attribute'=>'status',
                'value'=>function ($model, $key, $index, $widget) {
                return Uzers::getStatus($model->status);
                },
            ],
            'chasisno',
                [
                    'attribute'=>'capacity',
                    'value'=>function ($model, $key, $index, $widget) {
                    return Cars::getcarcapacity($model->capacity);
                    },
                    ],
                [
                    'attribute'=>'typeId',
                    'value'=>function ($model, $key, $index, $widget) {
                    return $model->type->name.' '.$model->type->model;
                    },
                    ],

            [
                'class' => 'yii\grid\ActionColumn',
                'template'=>'{view}{update}',
            ],
        ],
    ]); ?>
</div>