<?php

use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Accounts;
use app\models\Billcontent;
use app\models\Billpayments;

/* @var $this yii\web\View */
/* @var $searchModel app\models\BillsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'All paid bills';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="bills-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

     <p align="right">
        <?= Html::button('New bill',['value'=>\yii\helpers\Url::toRoute('create'),'class' => 'btn btn-success','id'=>'modalButton']) ?>
      </p>
    
        <?php 
Modal::begin([
    'options'=>[
        'tabindex' => false,
    ],
    'header'=>'',
    'id'=>'modal',
    'size'=>'modal-lg',
]);

echo '<div id="modalContent"></div>';

Modal::end();

?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            'id',
            [
                'attribute'=>'billby',
                'value'=>function ($model, $key, $index, $widget) {return $model->billby0->name.'-'.Accounts::getCurrency($model->currency); }
            ],
          
            'date',
            'dueDate',
            [
                'attribute'=>'billamount',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Billcontent::getBillCost($model->id)).'-'.Accounts::getCurrency($model->currency); }
            ],
            
            [
                'attribute'=>'paid amount',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Billpayments::getPaidByBill($model->id)).'-'.Accounts::getCurrency($model->currency); }
            ],
            
                                       [
                        'class' => 'yii\grid\ActionColumn',
                        'contentOptions' => ['style' => 'width:60px;'],
                        'header'=>'Actions',
                        'template' => '{view}',
                        'buttons' => [
                            
                            //view button
                            'view' => function ($url, $model) {
                            
                            return  '<div class="dropdown">
                          <a class="glyphicon glyphicon-tasks" type="button" data-toggle="dropdown">
                          <span class="caret"></span></a>
                          <ul class="dropdown-menu">
                         <li>'.Html::a('Record payment',['billpayments/create','id'=>$model->id], ['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('Delete',['bills/delete','id'=>$model->id], ['class' => 'glyphicon','data' => [
                              'confirm' => 'Are you sure you want to delete this item?',
                              'method' => 'post',
                          ]]).' </li>
                                
                          </ul>
                        </div>';
                          
                          
                            },
                            ],
                            
                            ],
        ],
    ]); ?>
</div>
