<?php

use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use app\models\Accounts;
use app\models\Billcontent;
use app\models\Bills;
use app\models\Billpayments;
use app\models\Clients;
use app\models\Invoices;
use app\models\Billname;

/* @var $this yii\web\View */
/* @var $searchModel app\models\BillsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'All bills and payments';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="bills-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php //echo $this->render('_search', ['model' => $searchModel]); ?>

     <p align="right">
        <?= Html::a('New bill', ['create'], ['class' => 'btn btn-success']) ?>
        <?= Html::a('New creditNote', ['creditnote'], ['class' => 'btn btn-success']) ?>
      </p>




<?php 

/* 
$bills=Bills::find()->where(['clientId'=>null])->all();
echo 'No of bills '.count($bills).'<br>';
$cnt=0;
if ($bills != null){
    foreach ($bills as $bill){
        $nm=strtolower(Accounts::findOne($bill->billby)->name);
        $cls=Clients::find()->all();
        
        if ($bill->billby==18){
            $bill->clientId=66;
            $bill->save();
        }
        
  if($cls != null){
            foreach ($cls as $cl){
                if (stripos($nm,$cl->name)!== false){
                echo $cnt.' - '.$cl->name.' '.$bill->id.'<br>';
                $bill->clientId=$cl->id;
                $bill->save();
               break;
                }
            }
        } 
        $cnt++;
    }
}

*/
 
/*

$cls=Bills::find()->all();
$c=1;
if ($cls != null){
    foreach ($cls as $cl){
        if ($cl->clientId==null){
            echo $c.' - '.$cl->id.'<br>';
            $c++;
        }
    }
}


*/

$contents= Billcontent::find()->where(['accId'=>null])->all();

if ($contents != null){
    foreach ($contents as $content){
        if ($content->accId==null){
            $content->accId=Bills::findOne($content->billId)->billby;
            $content->save();
        }
    }
}

?>



<?php 
/*
$invos=Bills::find()->all();
echo 'No of bills '.count($invos).'<br>';
$cnt=0;
if ($invos != null){
    foreach ($invos as $invo){
        $nm=strtolower(Accounts::findOne($invo->billby)->name);
        $cls=Clients::find()->all();
        
        if($cls != null){
            foreach ($cls as $cl){
                if (stripos($nm,$cl->name)!== false){
                echo $cnt.' - '.$cl->name.' '.$invo->id.'<br>';
                $invo->clientId=$cl->id;
                //$invo->save();
               break;
                }
            }
        }
        $cnt++;
    }
}




$cls=Invoices::find()->all();
$c=1;
if ($cls != null){
    foreach ($cls as $cl){
        if ($cl->clientId==null){
            echo $c.' - '.$cl->id.'<br>';
            $c++;
        }
    }
}
*/
?>


    
        <?php 
Modal::begin([
    'options'=>[
        'tabindex' => false,
    ],
    'header'=>'',
    'id'=>'modal',
    'size'=>'modal-lg',
]);

echo '<div id="modalContent"></div>';

Modal::end();

?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            
            [
                'attribute'=>'Status',
                'value'=>function ($model, $key, $index, $widget) {return $model->paid==0?'Pending':'Paid'; },
                'contentOptions' => function($model, $key, $index, $column){
                if ($model->paid==1){
                    return ['style' =>'background-color:#197777; color:white;'];
                }elseif ($model->paid==0){
                    return ['style' =>'background-color:#101CE0; color:white;'];
                }
                },
                ],
            [
                'attribute'=>'numbername',
                'value'=>function ($model, $key, $index, $widget) {return Bills::getBillNo(Bills::findOne($model->id)->company,$model->id); }
            ],
            [
                'attribute'=>'clientId',
                'value'=>function ($model, $key, $index, $widget) {return $model->client->name; }
            ],
            [
                'attribute'=>'date',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->date)); }
            ],
            [
                'attribute'=>'dueDate',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->dueDate)); }
            ],
            [
                'attribute'=>'billamount',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Billcontent::getBillCost($model->id),2).' '.Accounts::getCurrency($model->currency); }
            ],
            
            [
                'attribute'=>'paid amount',
                'value'=>function ($model, $key, $index, $widget) {return number_format(Billpayments::getPaidByBill($model->id)).'-'.Accounts::getCurrency($model->currency); }
            ],
            
            //'paid',
            //'company',
            //'currency',
            
               [
                'class' => 'yii\grid\ActionColumn',
                'contentOptions' => ['style' => 'width:60px;'],
                'header'=>'Actions',
                'template' => '{view}',
                'buttons' => [
                    
                    //view button
                    'view' => function ($url, $model) {
                    
                    return  '<div class="dropdown">
                          <a class="glyphicon glyphicon-tasks" type="button" data-toggle="dropdown">
                          <span class="caret"></span></a>
                          <ul class="dropdown-menu">
                          <li>'.Html::a('Update',['bills/update','id'=>$model->id], ['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('Download',['billcontent/printrequest','id'=>$model->id], ['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('Record payment',['billpayments/create','id'=>$model->id], ['class' => 'glyphicon']).' </li>
                          <li>'.Html::a('Delete',['bills/delete','id'=>$model->id], ['class' => 'glyphicon','data' => [
                              'confirm' => 'Are you sure you want to delete this item?',
                              'method' => 'post',
                          ]]).' </li>

                          </ul>
                        </div>';
                    
                    
                    },
                    ],
                    
                    ],
            
            
        ],
    ]); ?>
</div>