<?php

use app\models\Accounts;
use app\models\Billcontent;
use app\models\Billpayments;
use app\models\Bills;
use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model app\models\Billpayments */

$this->title = 'Update Billpayments: ' . $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Billpayments', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $model->id, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = 'Update';
?>
<div class="billpayments-update">

<table class="table table-striped table-bordered table-hover">
<tr>
<td><b>Client: </b><?php echo Bills::findOne($model->billId)->client->name; ?> </br><b>Bill #: </b><?php echo $model->billId; ?></td>
<td><b>Billed on: </b><?php echo date('d-m-Y',strtotime(Bills::findOne($model->billId)->date));?> </br><b>Due date: </b><?php echo date('d-m-Y',strtotime(Bills::findOne($model->billId)->dueDate));?></td>
<td><b>Total cost: </b><?php echo number_format(Billcontent::getBillCost($model->billId),2).' '.Accounts::getCurrency(Bills::findOne($model->billId)->currency); ?></br><b>Total paid: </b><?php echo number_format(Billpayments::getPaidByBill($model->billId),2).' '.Accounts::getCurrency(Bills::findOne($model->billId)->currency); ?></td>
<td><b>Comments</b><?php echo Bills::findOne($model->billId)->comment; ?></br></br></td>
</tr>
</table> 

    <?= $this->render('_form', [
        'model' => $model,
    ]) ?>

</div>
