<?php

use app\models\Accounts;
use app\models\Billpayments;
use app\models\Bills;
use yii\helpers\Html;
use app\models\Billcontent;

/* @var $this yii\web\View */
/* @var $model app\models\Billpayments */

$this->title = 'Record bill payment';
$this->params['breadcrumbs'][] = ['label' => 'Bills', 'url' => ['bills/index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="billpayments-create">

    <h3 align="center"><?= Html::encode($this->title) ?></h3>
    
        <p align="right">
        <?= Html::a('', ['billcontent/printrequest','id'=>$id], ['class' => 'glyphicon glyphicon-download-alt']) ?>
          </p>
    
    </br>
    
<table class="table table-striped table-bordered table-hover">
<tr>
<td><b>Client: </b><?php echo Bills::findOne($id)->client->name; ?> </br><b>Bill #: </b><?php echo Bills::getBillNo(Bills::findOne($id)->company,$id); ?></td>
<td><b>Billed on: </b><?php echo date('d-m-Y',strtotime(Bills::findOne($id)->date));?> </br><b>Due date: </b><?php echo date('d-m-Y',strtotime(Bills::findOne($id)->dueDate));?></td>
<td><b>Total cost: </b><?php echo number_format(Billcontent::getBillCost($id),2).' '.Accounts::getCurrency(Bills::findOne($id)->currency); ?></br><b>Total paid: </b><?php echo number_format(Billpayments::getPaidByBill($id),2).' '.Accounts::getCurrency(Bills::findOne($id)->currency); ?></td>
<td><b>Comments</b><?php echo Bills::findOne($id)->comment; ?></br></br></td>
</tr>
</table>  


<h4>Bill records</h4>
<?php 
$contents= Billcontent::find()->where(['billId'=>$id])->all(); 

if ($contents != null){  ?>

  <table class="table table-striped table-bordered table-hover">
                              <thead>
                                 <tr>
                                    <th>Service/Product</th>
                                     <th>Amount</th>
                                     <th>Quantity</th>
                                    <th>Total</th>
                                    </tr></thead>

<?php  foreach ($contents as $content){   ?>
       <tr>
                                    <td><?php echo $content->service->name; ?></td>
                                     <td><?php echo number_format($content->amount,2); ?></td>
                                      <td><?php echo $content->count; ?></td>
                                    <td> <?php echo number_format(($content->amount*$content->count),2) ?></td>
                                    </tr> 
        
        <?php  }  }  ?>
        
 </table>   

<h4>Payment records</h4>
<?php 
$payments= Billpayments::find()->where(['billId'=>$id])->all(); 

if ($payments != null){  ?>

  <table class="table table-striped table-bordered table-hover">
                              <thead>
                                 <tr>
                                    <th>Payment date</th>
                                     <th>Amount</th>
                                     <th>Check no</th>
                                    <th></th>
                                    </tr></thead>

<?php  foreach ($payments as $payment){   ?>
       <tr>
                                    <td><?php echo date('d-M-Y',strtotime($payment->date)); ?></td>
                                     <td><?php echo number_format($payment->amount,2); ?></td>
                                      <td><?php echo $payment->checkNo; ?></td>
                                    <td><?= Html::a('', ['delete', 'id' => $payment->id], [
            'class' => 'glyphicon glyphicon-trash',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
        
         
        <?= Html::a('', ['update', 'id' => $payment->id], [
            'class' => 'glyphicon glyphicon-pencil',
        ]) ?>
        </td>
                                    </tr> 
        
        <?php
    }
}

?>
 </table>   

    <?= $this->render('_form', [
        'model' => $model,
    ]) ?>

</div>
