<?php

use app\models\Accounts;
use app\models\Billcontent;
use app\models\Bills;
use app\models\Cars;
use app\models\Services;
use yii\grid\GridView;
use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model app\models\Billcontent */

$this->title = 'Update bill';
$this->params['breadcrumbs'][] = ['label' => 'Billcontents', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $model->id, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = 'Update';
?>
<div class="billcontent-update">

    <h3 align="center"><?= Html::encode($this->title) ?></h3>
    
    <h4>Bill #: <?php echo $model->billId; ?></br> Bill by:<?php echo Bills::findOne($model->billId)->client->name; ?> </br> Billed on: <?php echo date('d-m-Y',strtotime(Bills::findOne($model->billId)->date));?></br>Due date: <?php echo date('d-m-Y',strtotime(Bills::findOne($model->billId)->dueDate));?> </h4>



 <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'serviceId',
                'value'=>function ($model, $key, $index, $widget) {return Services::findOne($model->serviceId)->name; }
            ],
            
            [
                'attribute'=>'car',
                'value'=>function ($model, $key, $index, $widget) {return $model->carId !=null?$model->carId.' ('. Cars::findOne($model->carId)->type->name.')':' '; }
            ],
            
            
            [
                'attribute'=>'Last cost',
                'value'=>function ($model, $key, $index, $widget) {return Billcontent::getLastbillServiceCost($model->billId,$model->serviceId)==null?'':number_format(Billcontent::getLastbillServiceCost($model->billId,$model->serviceId)->amount,2)
                .' - '.Billcontent::getTruckNoByBillAndService($model->billId,$model->serviceId); }
            ],
            
            [
                'attribute'=>'amount',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->amount,2); }
            ],
            
            [
                'attribute'=>'count',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->count); }
            ],
            
            [
                'attribute'=>'total',
                'value'=>function ($model, $key, $index, $widget) {return number_format(($model->count*$model->amount),2); }
            ],

            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{update}'
            ],
            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{delete}'
            ],
        ],
    ]); ?>
    
    &nbsp;

    <?= $this->render('_formold', [
        'model' => $model,'c'=>$model->bill->currency,
    ]) ?>

</div>
