<?php

use app\models\Accounts;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use yii\helpers\Html;
use app\models\Bills;
use app\models\Cars;
use app\models\Services;
use app\models\Billcontent;

/* @var $this yii\web\View */
/* @var $model app\models\Billcontent */

$this->title = 'Workshop payment request';
$this->params['breadcrumbs'][] = ['label' => 'Billcontents', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="billcontent-create">

    <h3  align="center"><?= Html::encode($this->title) ?></h3>
    
        <p align="left">
        <?= Html::a('', ['billcontent/printrequest','id'=>$id], ['class' => 'glyphicon glyphicon-download-alt']) ?>
           <p align="right">
        <?= Html::button('New spare/tool',['value'=>\yii\helpers\Url::toRoute('services/createworkshop'),'class' => 'btn btn-success','id'=>'modalButton']) ?>
      </p>
      
    </p>
    
    <?php 
Modal::begin([
    'options'=>[
        'tabindex' => false,
    ],
    'header'=>'',
    'id'=>'modal',
    'size'=>'modal-lg',
]);

echo '<div id="modalContent"></div>';

Modal::end();

?>
    

<p><b>Bill #: </b><?php echo Bills::getBillNo(Bills::findOne($id)->company,$id); ?></br> <b>Client: </b><?php echo Bills::findOne($id)->client->name; ?> </br> <b>Currency:</b> <?php echo Bills::getPaytype(Bills::findOne($id)->paytype).'-'.Accounts::getCurrency(Bills::findOne($id)->currency); ?> 
</br> <b>Billed on: </b><?php echo date('d-m-Y',strtotime(Bills::findOne($id)->date));?></br><b>Due date: </b><?php echo date('d-m-Y',strtotime(Bills::findOne($id)->dueDate));?> </br><b>Comment:</b><?php echo Bills::findOne($id)->comment;?>  </p>

 <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'serviceId',
                'value'=>function ($model, $key, $index, $widget) {return Services::findOne($model->serviceId)->name; }
            ],
            
            [
                'attribute'=>'car',
                'value'=>function ($model, $key, $index, $widget) {return $model->carId !=null?$model->carId.' ('. Cars::findOne($model->carId)->type->name.')':' '; }
            ],
            
            [
                'attribute'=>'Last cost',
                'value'=>function ($model, $key, $index, $widget) {return Billcontent::getLastbillServiceCost($model->billId,$model->serviceId)==null?'':number_format(Billcontent::getLastbillServiceCost($model->billId,$model->serviceId)->amount,2).' - '.Billcontent::getLastbillServiceCost($model->billId,$model->serviceId)->billId.' ('. Cars::findOne(Billcontent::getLastbillServiceCost($model->billId,$model->serviceId)->carId)->type->name.')'; }
            ],
            
            
            [
                'attribute'=>'amount',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->amount,2); }
            ],
            
            [
                'attribute'=>'count',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->count); }
            ],
            
            [
                'attribute'=>'total',
                'value'=>function ($model, $key, $index, $widget) {return number_format(($model->count*$model->amount),2); }
            ],
            
            [
                'label'=>' ',
                'format' => 'raw',
                'value'=>function ($model, $key, $index, $widget) {
                return Html::a('',['billcontent/updateworkshop','id'=>$model->id],[
                    'class' => 'glyphicon glyphicon-edit',
                ]);
                },
                ],
            
            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{delete}'
            ],
        ],
    ]); ?>
    
    <?php if (Bills::findOne($id)->status==0) { ?>

    <?= $this->render('_formworkshop', [
        'models' => $models,'c'=>Bills::findOne($id)->currency,
    ]) ?>
    
    <?php }else { ?>

 <p><?= Html::a('', ['bills/unlock','id'=>$id], ['class' => 'glyphicon glyphicon-check']) ?>
        Bill locked 
</p>

<?php } ?>
    

</div>
