<?php

use app\models\Accounts;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use yii\helpers\Html;
use app\models\Bills;
use app\models\Services;
use app\models\Billcontent;

/* @var $this yii\web\View */
/* @var $model app\models\Billcontent */

$this->title = 'Request for quotation form';
$this->params['breadcrumbs'][] = ['label' => 'Billcontents', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="billcontent-create">

    <h3  align="center"><?= Html::encode($this->title) ?></h3>
    
        <p align="left">
        <?= Html::a('', ['billcontent/printrequest','id'=>$id], ['class' => 'glyphicon glyphicon-download-alt']) ?>
           <p align="right">
        <?= Html::button('New spare/tool',['value'=>\yii\helpers\Url::toRoute('services/createworkshop'),'class' => 'btn btn-success','id'=>'modalButton']) ?>
      </p>
      
    </p>
    
    <?php 
Modal::begin([
    'options'=>[
        'tabindex' => false,
    ],
    'header'=>'',
    'id'=>'modal',
    'size'=>'modal-lg',
]);

echo '<div id="modalContent"></div>';

Modal::end();

?>
    

<p><b>Bill #: </b><?php echo Bills::getBillNo(Bills::findOne($id)->company,$id); ?></br> <b>Bill by: </b><?php echo Bills::findOne($id)->billby0->name; ?> </br> <b>Currency:</b> <?php echo Bills::getPaytype(Bills::findOne($id)->paytype).'-'.Accounts::getCurrency(Bills::findOne($id)->currency); ?> 
</br> <b>Billed on: </b><?php echo date('d-m-Y',strtotime(Bills::findOne($id)->date));?></br><b>Due date: </b><?php echo date('d-m-Y',strtotime(Bills::findOne($id)->dueDate));?> </p>

 <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'serviceId',
                'value'=>function ($model, $key, $index, $widget) {return Services::findOne($model->serviceId)->name; }
            ],
            
            [
                'attribute'=>'car',
                'value'=>function ($model, $key, $index, $widget) {return $model->carId; }
            ],
            
            [
                'attribute'=>'count',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->count); }
            ],     
            
            [
                'label'=>' ',
                'format' => 'raw',
                'value'=>function ($model, $key, $index, $widget) {
                return Html::a('',['billcontent/updateworkshop','id'=>$model->id],[
                    'class' => 'glyphicon glyphicon-edit',
                ]);
                },
                ],
            
            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{delete}'
            ],
        ],
    ]); ?>

    <?= $this->render('_formrfq', [
        'model' => $model,'c'=>Bills::findOne($id)->currency,
    ]) ?>

</div>
