<?php

use app\models\Accounts;
use yii\bootstrap\Modal;
use yii\grid\GridView;
use yii\helpers\Html;
use app\models\Billcontent;
use app\models\Bills;
use app\models\Cfile;
use app\models\Packages;
use app\models\Services;

/* @var $this yii\web\View */
/* @var $model app\models\Billcontent */

if (\Yii::$app->session->get('fileId')==null) $tit= ''; else $tit=Cfile::findOne(\Yii::$app->session->get('fileId'))->blnumber;

$this->title = 'Bl #'.$tit.' payment request';
$this->params['breadcrumbs'][] = ['label' => 'Billcontents', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="billcontent-create">

    <h3  align="center"><?= Html::encode($this->title) ?></h3>
    
        <p align="left">
        <?= Html::a('', ['billcontent/printrequest','id'=>$id], ['class' => 'glyphicon glyphicon-download-alt']) ?>
           <p align="right">
        <?= Html::button('New service/product',['value'=>\yii\helpers\Url::toRoute('services/create'),'class' => 'btn btn-success','id'=>'modalButton']) ?>
      </p>
      
    </p>
    
    
        <?php 
    
    $treatmentcharges=Services::getServiceByName('treatment cost',Bills::findOne($id)->currency);
    $inspection=Services::getServiceByName('Export inspection',Bills::findOne($id)->currency);
    $phytosanitary=Services::getServiceByName('Phytosanitary certificate cost',Bills::findOne($id)->currency);
    $customamendment=Services::getServiceByName('Customs amendment cost(export)',Bills::findOne($id)->currency);
    $emptytransportationcharges=Services::getServiceByName('Empty transportation charges(Export)',Bills::findOne($id)->currency);
    $fulltransportationcharges=Services::getServiceByName('Full transportation charges(export)',Bills::findOne($id)->currency);
    $shippingline=Services::getServiceByName('Shipping line charges',Bills::findOne($id)->currency);
    $wharfagecharges=Services::getServiceByName('Wharfage charges',Bills::findOne($id)->currency);
    $emptydrop=Services::getServiceByName('Empty dropping charges',Bills::findOne($id)->currency);
    $offloading=Services::getServiceByName('Offloading charges',Bills::findOne($id)->currency);
    $staffing=Services::getServiceByName('Stuffing charges(export)',Bills::findOne($id)->currency);
    $directstaffing=Services::getServiceByName('Direct stuffing charges',Bills::findOne($id)->currency);
    $loading=Services::getServiceByName('Full container loading charges',Bills::findOne($id)->currency);
    $lineprocessing=Services::getServiceByName('Shippingline processing costs',Bills::findOne($id)->currency);
    $quantity20=Packages::getQuantityByType(2);
    $dropoff40=Services::getServiceByName('Drop off cost 40ft',Bills::findOne($id)->currency);
    $quantity40=Packages::getQuantityByType(4);
    $transcost=Services::getServiceByName('Transportation cost',Bills::findOne($id)->currency);
    $dt=date('Y-m-d');
    $exposervice=Services::getServiceByName('export service charges',Bills::findOne($id)->currency);
    $agriprocessing=Services::getServiceByName('Agriculture processing costs',Bills::findOne($id)->currency);
    $handlingcharges=Services::getServiceByName('Handling charges(export)',Bills::findOne($id)->currency);
    $amendmentfee=Services::getServiceByName('Amendment fee(export)',Bills::findOne($id)->currency);
    $certificationcost=Services::getServiceByName('Certification fee(export)',Bills::findOne($id)->currency);
    $cnt=0;
    
    ?>
    
    <?php 
Modal::begin([
    'options'=>[
        'tabindex' => false,
    ],
    'header'=>'',
    'id'=>'modal',
    'size'=>'modal-lg',
]);

echo '<div id="modalContent"></div>';

Modal::end();

?>
<table class="table">    
<tr><td width="250px">
<p><b>Bill #: </b><?php echo Bills::getBillNo(Bills::findOne($id)->company,$id); ?></br> <b>Client:</b><?php echo Bills::findOne($id)->client->name; ?> </br> <b>Currency:</b> <?php echo Bills::getPaytype(Bills::findOne($id)->paytype).'-'.Accounts::getCurrency(Bills::findOne($id)->currency); ?> 
</br> <b>Billed on: </b><?php echo date('d-m-Y',strtotime(Bills::findOne($id)->date));?></br><b>Due date:</b><?php echo date('d-m-Y',strtotime(Bills::findOne($id)->dueDate));?></br><b>Comment:</b><?php echo Bills::findOne($id)->comment;?>  </p>
</td>
<td>

<?php 
$cnt=1;
if (\Yii::$app->session->get('fileId')!=null){
    if (Cfile::findOne(\Yii::$app->session->get('fileId'))->ftype==2){
        ?>
        <b>Unbilled export services<br></b>
        
        <?php
        if ($offloading != null){
            if(Billcontent::checkServiceInBillByFile($offloading->id,$id,\Yii::$app->session->get('fileId'))==null and (Services::findOne($offloading->id)->currency ==Bills::findOne($id)->currency)){
                echo $offloading->name.' | ';
            }  
        }if ($emptytransportationcharges != null){
            if(Billcontent::checkServiceInBillByFile($emptytransportationcharges->id,$id,\Yii::$app->session->get('fileId'))==null and (Services::findOne($emptytransportationcharges->id)->currency ==Bills::findOne($id)->currency)){
                echo $emptytransportationcharges->name.' | ';
            }
        }if ($emptydrop != null){
            if (Billcontent::checkServiceInBillByFile($emptydrop->id,$id,\Yii::$app->session->get('fileId'))==null and (Services::findOne($emptydrop->id)->currency ==Bills::findOne($id)->currency)){
                echo $emptydrop->name.' | ';
            }
        }if ($staffing != null){
            if(Billcontent::checkServiceInBillByFile($staffing->id,$id,\Yii::$app->session->get('fileId'))==null and (Services::findOne($staffing->id)->currency ==Bills::findOne($id)->currency)){
                echo $staffing->name.' | ';
            }
        }if ($directstaffing != null){
            if(Billcontent::checkServiceInBillByFile($directstaffing->id,$id,\Yii::$app->session->get('fileId'))==null and (Services::findOne($directstaffing->id)->currency ==Bills::findOne($id)->currency)){
                echo $directstaffing->name.'<br> ';
            }
        }if ($loading != null){
            if(Billcontent::checkServiceInBillByFile($loading->id,$id,\Yii::$app->session->get('fileId'))==null and (Services::findOne($loading->id)->currency ==Bills::findOne($id)->currency)){
                echo $loading->name.' | ';
            }
        }if ($fulltransportationcharges != null){
            if(Billcontent::checkServiceInBillByFile($fulltransportationcharges->id,$id,\Yii::$app->session->get('fileId'))==null and (Services::findOne($fulltransportationcharges->id)->currency ==Bills::findOne($id)->currency)){
                echo $fulltransportationcharges->name.' | '; 
            }
        }if ($treatmentcharges != null){
            if(Billcontent::checkServiceInBillByFile($treatmentcharges->id,$id,\Yii::$app->session->get('fileId'))==null and (Services::findOne($treatmentcharges->id)->currency ==Bills::findOne($id)->currency)){
                echo $treatmentcharges->name.' | ';
            }
        }if ($inspection != null){
            if(Billcontent::checkServiceInBillByFile($inspection->id,$id,\Yii::$app->session->get('fileId'))==null and (Services::findOne($inspection->id)->currency ==Bills::findOne($id)->currency)){
                echo $inspection->name.' | ';
            }
        } if ($phytosanitary != null){
            if(Billcontent::checkServiceInBillByFile($phytosanitary->id,$id,\Yii::$app->session->get('fileId'))==null and (Services::findOne($phytosanitary->id)->currency ==Bills::findOne($id)->currency)){
                echo $phytosanitary->name. '<br>';
            }
        }if ($agriprocessing != null){
            if(Billcontent::checkServiceInBillByFile($agriprocessing->id,$id,\Yii::$app->session->get('fileId'))==null and (Services::findOne($agriprocessing->id)->currency ==Bills::findOne($id)->currency)){
                echo $agriprocessing->name.' | ';
            }
        } if ($customamendment != null){
            if(Billcontent::checkServiceInBillByFile($customamendment->id,$id,\Yii::$app->session->get('fileId'))==null and (Services::findOne($customamendment->id)->currency ==Bills::findOne($id)->currency)){
                echo $customamendment->name.' | '; 
            }
        }if ($wharfagecharges != null){
            if(Billcontent::checkServiceInBillByFile($wharfagecharges->id,$id,\Yii::$app->session->get('fileId'))==null and (Services::findOne($wharfagecharges->id)->currency ==Bills::findOne($id)->currency)){
                echo $wharfagecharges->name.' | ';
            }
        }if ($handlingcharges != null){
            if(Billcontent::checkServiceInBillByFile($handlingcharges->id,$id,\Yii::$app->session->get('fileId'))==null and (Services::findOne($handlingcharges->id)->currency ==Bills::findOne($id)->currency)){
                echo $handlingcharges->name.' | ';
            }
        } if ($amendmentfee != null){
            if(Billcontent::checkServiceInBillByFile($amendmentfee->id,$id,\Yii::$app->session->get('fileId'))==null and (Services::findOne($amendmentfee->id)->currency ==Bills::findOne($id)->currency)){
                echo $amendmentfee->name.'<br>';
            }
        } if ($shippingline != null){
            if(Billcontent::checkServiceInBillByFile($shippingline->id,$id,\Yii::$app->session->get('fileId'))==null and (Services::findOne($shippingline->id)->currency ==Bills::findOne($id)->currency)){
                echo $shippingline->name.' | '; 
            }
        }if ($certificationcost != null){
            if(Billcontent::checkServiceInBillByFile($certificationcost->id,$id,\Yii::$app->session->get('fileId'))==null and (Services::findOne($certificationcost->id)->currency ==Bills::findOne($id)->currency)){
                echo $certificationcost->name.' | ';
            }
        }if ($lineprocessing != null){
            if(Billcontent::checkServiceInBillByFile($lineprocessing->id,$id,\Yii::$app->session->get('fileId'))==null and (Services::findOne($lineprocessing->id)->currency ==Bills::findOne($id)->currency)){
                echo $lineprocessing->name.' | ';
            }
        }
    }
}


?>
</td>
</tr>
</table>


 <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute'=>'serviceId',
                'value'=>function ($model, $key, $index, $widget) {return Services::findOne($model->serviceId)->name; }
            ],
            [
                'attribute'=>'amount',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->amount,2); }
            ],
            
            [
                'attribute'=>'count',
                'value'=>function ($model, $key, $index, $widget) {return number_format($model->count); }
            ],
            
            [
                'attribute'=>'total',
                'value'=>function ($model, $key, $index, $widget) {return number_format(($model->count*$model->amount),2).' '.Accounts::getCurrency(Services::findOne($model->serviceId)->currency); }
            ],

            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{update}'
            ],
            ['class' => 'yii\grid\ActionColumn',
                'template'=>'{delete}'
            ],
        ],
    ]); ?>
    
    <?php  
    /*
    if (\Yii::$app->session->get('fileId')!=null){
    if (Cfile::findOne(\Yii::$app->session->get('fileId'))->ftype==2){?>
    
     <?= $this->render('_expoform', [
        'model' => $model,'id'=>$id,
    ]) ?>
    
    <?php }else{ ?>


    
    <?php } }   */ ?>
    
    <?php if (Bills::findOne($id)->status==0) { ?>
    
        <?= $this->render('_form', [
        'models' => $models,'c'=>Bills::findOne($id)->currency,
    ]) ?>
    
    <?php }else { ?>

 <p><?= Html::a('', ['bills/unlock','id'=>$id], ['class' => 'glyphicon glyphicon-check']) ?>
        Bill locked 
</p>

<?php } ?>

</div>
