<?php

use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use app\models\Accountstype;
use kartik\select2\Select2;

/* @var $this yii\web\View */
/* @var $model app\models\Accounts */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="accounts-form">

<?php $types = ArrayHelper:: map (Accountstype::find()-> all() , 'id' , function($model, $defaultValue){ return $model->name; }); ?>


    <?php $form = ActiveForm::begin([
        'fieldConfig' => [
            'template' => " <div class='row'><div class='col-xs-11'>{label}{input}{error}{hint}</div></div>",
        ],
    ]); ?>
    
    <table width="100%">
<tr>
    
     <td> <?= $form->field($model, 'company')->dropdownList([
     1 => 'ITL',
     2 => 'IMSL',
     3 => 'EBM TZ',
     4 => 'TASHICOL',
    ],
     [
         'style'=>'length:20px',
         'prompt'=>'-select-'
         
     ]
);?></td>

 <td> <?= $form->field($model, 'status')->dropdownList([
        1 => 'Active', 
        2 => 'Dormant',
    ],
     [
         'style'=>'length:20px',
         'prompt'=>'-select-'
         
     ]
);?></td>

 <td> <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?> </td>

<td> <?= $form->field($model, 'number')->textInput(['maxlength' => true]) ?></td>

<td><?= $form->field($model, 'openBalance')->textInput(['maxlength' => true]) ?></td>

 <td> <?= $form->field($model, 'cur')->dropdownList([
        1 => 'Tsh', 
        2 => 'Usd',
    ],
     [
         'style'=>'length:20px',
         'prompt'=>'-select-'
         
     ]
);?></td>

</tr>
</table>

<table>
<tr>
<td>
    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>
</td>
</tr>
</table>


    <?php ActiveForm::end(); ?>

</div>