<?php

use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\models\WstoredispatchSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Store dispatch request';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wstoredispatch-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

      <p align="right">
         <?= Html::button('New dispatch',['value'=>\yii\helpers\Url::toRoute('create'),'class' => 'btn btn-success','id'=>'modalButton']) ?>
    </p>
    
     <?php 
        Modal::begin([
            'options'=>[
                'tabindex' => false,
            ],
            'header'=>'',
            'id'=>'modal',
            'size'=>'modal-lg',
        ]);
        
        echo '<div id="modalContent"></div>';
        
        Modal::end();

?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'byy',
            [
                'attribute'=>'truckId',
                'value'=>function ($model, $key, $index, $widget) {return $model->truckId; }
            ],
            [
                'attribute'=>'date',
                'value'=>function ($model, $key, $index, $widget) {return date('d-m-Y',strtotime($model->date)); }
            ],
            [
                'label'=>' ',
                'format' => 'raw',
                'value'=>function ($model, $key, $index, $widget) {
                return Html::a('',['dispatchcontents/create','id'=>$model->id],['class' => 'glyphicon glyphicon-tasks']);
                },
                ],
        ],
    ]); ?>
</div>
