<?php 
use app\models\Accounts;
use app\models\Cars;
use app\models\Cartype;
use app\models\Services;
use app\models\Invoices;
use yii\helpers\Html;
use app\models\Statistics;
use app\models\Movetype;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

?>

<table width="100%">
<tr>
<td width="30%" align="center">
<?php if(\Yii::$app->session->get('company')==1){ echo Html::img("img/itl.jpg"); }elseif (\Yii::$app->session->get('company')==2){ echo Html::img("img/imsl.jpg"); } ?> 
</td>
</tr></table>

<?php 
?>


<h3 align="center">Op statistics report from <?php echo $from; ?> to <?php echo $to; ?></h3>

<?php 
$trucks=Cars::find()->where(['typeId' =>Cartype::getHorsesId(),'status'=>1,'company'=>\Yii::$app->session->get('company')])-> all();

$count=0;
$avarage=array();
$records=array();
$totalExpectedTsh=0;
$totalExpectedUsd=0;
$rm=0;
$f=date('Y-m-d',strtotime($from));
$t=date('Y-m-d',strtotime($to));

$moveaverage=array();
$moverecords=array();
$moveexpected=0;
$cnt=0;

if ($trucks != null){
  
    
    foreach ($trucks as $truck){
        $expincomeUsd=Statistics::getTruckExpectedIncomeByTime($truck->plateno,$f,$t,2);
        $expincomeTsh=Statistics::getTruckExpectedIncomeByTime($truck->plateno,$f,$t,1);
        
            if(($expincomeTsh+$expincomeUsd) > 0){
                $records[$count]['id']=$truck->plateno;
                $records[$count]['eincomeTsh']=$expincomeTsh;
                $records[$count]['eincomeUsd']=$expincomeUsd;
                $avarage[$count]['av']=$expincomeTsh+$expincomeUsd;
                $totalExpectedTsh=$totalExpectedTsh+$expincomeTsh;
                $totalExpectedUsd=$totalExpectedUsd+$expincomeUsd;
                $count++;
            }
    }
   if ($avarage !=null and $records != null) array_multisort($avarage,SORT_DESC,$records);
}

$movetypes= Movetype::find()->all();

if ($movetypes!= null){
    
    foreach ($movetypes as $mvt){
        $moveexp=Statistics::getExpectedIncomeByMove($mvt->id,$f,$t,$mvt->currency);
        
        if ($moveexp>0){
            
            $moverecords[$cnt]['name']=$mvt->name;
            $moverecords[$cnt]['twenty']=Statistics::getExpectedQuantityByMoveandSize($mvt->id,2,$f,$t);
            $moverecords[$cnt]['forty']=Statistics::getExpectedQuantityByMoveandSize($mvt->id,4,$f,$t);
            $moverecords[$cnt]['expinc']=$moveexp;
            $moverecords[$cnt]['tinvolved']=Statistics::getQuantityOfTrucksInvolved($mvt->id,$f,$t);
            $moverecords[$cnt]['currency']=Accounts::getCurrency($mvt->currency);
            $moveaverage[$cnt]['av']=$moveexp;
            $cnt++;
        }
    }
   if($moveaverage != null and $moverecords != null) array_multisort($moveaverage,SORT_DESC,$moverecords);
}
?>

</br></br>

<table width="100%">
<tr><th style ="border-bottom:1px solid black;">MOVEMENTS</th><th style ="border-bottom:1px solid black;">40ft</th><th style ="border-bottom:1px solid black;">20ft</th>
<th style ="border-bottom:1px solid black;">TRUCKS INV</th><th style ="border-bottom:1px solid black;">EXP INC</th></tr>

<?php if ($moverecords != null){ for ($i=0; $i<count($moverecords); $i++){  ?>
  <tr><td style ="border-bottom:1px solid black;"><?php echo $moverecords[$i]['name']; ?></td> <td style ="border-bottom:1px solid black;"><?php echo $moverecords[$i]['forty']; ?></td> <td style ="border-bottom:1px solid black;"><?php echo $moverecords[$i]['twenty']; ?></td> 
  <td style ="border-bottom:1px solid black;"><?php echo $moverecords[$i]['tinvolved']; ?></td><td style ="border-bottom:1px solid black;"><?php echo number_format($moverecords[$i]['expinc']).'-'.$moverecords[$i]['currency']; ?></td></tr>
<?php  } } ?>

</table>

</br></br>


<table width="100%"><tr><th style ="border-bottom:1px solid black;">TOTAL EXPECTED INCOME(Usd)</th><th style ="border-bottom:1px solid black;"><?php echo number_format($totalExpectedUsd); ?></th>
<th style ="border-bottom:1px solid black;">TOTAL EXPECTED INCOME(Tsh)</th><th style ="border-bottom:1px solid black;"><?php echo number_format($totalExpectedTsh); ?></th></tr></table>


<h3>Descriptions</h3>

<table width="100%">
<tr nobr="true"><td width="25px" style ="border-bottom:1px solid black;"><b>#</b></td><td width="70px" align="left" style ="border-bottom:1px solid black;"><b>TRUCK</b></td><td width="470px" align="left" style ="border-bottom:1px solid black;">
<b>MOVEMENTS</b></td><td width="70px" align="center" style ="border-bottom:1px solid black;"><b>SUB-T</b></td></tr>



<?php for($j=0; $j<count($records); $j++){ 
    $stats=Statistics::getTruckStatisticsByTime($records[$j]['id'],$f,$t);
    ?>

<tr nobr="true">

<?php if ($stats != null){  ?>

<td style ="border-bottom:1px solid black;"><?php echo $j+1; ?></td><td align="left" style ="border-bottom:1px solid black;"><?php echo $records[$j]['id']; ?></td> <td align="left" style ="border-bottom:1px solid black;">    
    
<?php

foreach($stats as $stat){
    if ($stat->size !=0) $sz=$stat->size.'0 ft'; else $sz='Others';
    
    echo '<b>'.$stat->movetype0->name.'</b> | '.$stat->quantity.' - '.$sz.' | '.$stat->driver0->user->fullName.' | '.date('d-m-Y',strtotime($stat->date)).' | '. number_format($stat->quantity*Statistics::getExpectedIncome($stat->movetype,$stat->size,$stat->Movetype0->currency)).'-'.Accounts::getCurrency($stat->Movetype0->currency);
    
    echo '<br />';
}   ?> 
   
   </td><td align="center" style ="border-bottom:1px solid black;"><?php echo number_format($records[$j]['eincomeTsh']).'-Tsh';?> <br/>
   <?php echo number_format($records[$j]['eincomeUsd']).'-Usd';?> 
   </td>
    
   <?php  } ?>  </tr>

<?php } ?></table>


