<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use app\models\Accounts;
use app\models\Cartype;
use app\models\Movefuelratio;
use app\models\Movetype;

/* @var $this yii\web\View */
/* @var $model app\models\Movetype */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => 'Movetypes', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="movetype-view">

    <h3><?= Html::encode($this->title) ?></h3>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'name',
            [
                'attribute'=>'triptype',
                'value'=>Movetype::getTripType($model->triptype),
            ],
            'incentive',
            [
                'attribute'=>'twentypay',
                'value'=>number_format($model->twentypay).' '.Accounts::getCurrency($model->currency),
            ],
            [
                'attribute'=>'fortypay',
                'value'=>number_format($model->fortypay).' '.Accounts::getCurrency($model->currency),
            ],
            'otherpay',
        ],
    ]) ?>

</div>

<h3>Movement consumption by different cars</h3>

<table class="table table-bordered">
  <tr>
  <?php  
  $types= Cartype::find()
  ->where(['NOT LIKE','name','trailer'])
  ->all();
  
  $cnt=1;
  if ($types != null){
      foreach ($types as $type){
          
          $typeratio= Movefuelratio::find()
          ->where(['cartypeId'=>$type->id, 'movetypeId'=>$model->id])
          ->one();
          $tr=$typeratio!=null?$typeratio->moveconsumption:' Not set ';
  ?>
    <th><?php echo $type->name.' :'.$tr; ?></th>
    
    <?php if(($cnt%5)==0){ ?>
    </tr><tr>
    <?php }  $cnt++; } } ?>
  </tr>
</table>

