<?php

use app\models\Accounts;
use app\models\Invcontent;
use app\models\Invoices;
use app\models\Invopayments;
use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model app\models\Invopayments */

$this->title = 'Record payments';
$this->params['breadcrumbs'][] = ['label' => 'Invopayments', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="invopayments-create">

    <h3 align="center"><?= Html::encode($this->title) ?></h3>
    
    <h4>Invoice #: <?php echo $id; ?></br> Invoice to: <?php echo Invoices::findOne($id)->acc->name.'-'.Accounts::getCurrency(Invoices::findOne($id)->acc->currency); ?> </br>Date: <?php echo date('d-m-Y',strtotime(Invoices::findOne($id)->date));?> 
    </br>Invoice Amount: <?php echo number_format(Invcontent::getInvoiceCost($id)).' '.Accounts::getCurrency(Invoices::findOne($id)->acc->currency); ?> </br> Paid Amount: <?php echo number_format(Invopayments::getInvoicePaidAmount($id)); ?>  </br> Balance: <?php echo number_format(Invcontent::getInvoiceCost($id)-Invopayments::getInvoicePaidAmount($id)).' '.Accounts::getCurrency(Invoices::findOne($id)->acc->currency);  ?>
    </h4>
    
<br/>  <br/>
    <?= $this->render('_form', [
        'model' => $model,
    ]) ?>

</div>
