<?php

use app\models\Accounts;
use app\models\Services;
use kartik\depdrop\DepDrop;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;
use app\models\Cfbills;
use app\models\Billcontent;
use app\models\Invcontent;
use app\models\Invoices;
use app\models\Servicecost;
use app\models\Packages;

/* @var $this yii\web\View */
/* @var $model app\models\Invcontent */
/* @var $form yii\widgets\ActiveForm */
?>


<div class="invcontent-form">

    <?php $form = ActiveForm::begin([
        'fieldConfig' => [
            'template' => " <div class='row'><div class='col-xs-11'>{label}{input}{error}{hint}</div></div>",
        ],
    ]); ?>
    
<table class="table table-striped table-bordered table-hover">
<tr><th></th><th>Service</th><th>Cost</th></tr>

<?php 
$bills= Cfbills::find()->where(['fileId'=>Invoices::findOne($id)->fileId])->all();
$cnt=1;
if ($bills != null){
    foreach ($bills as $bill){
        $billcontents=Billcontent::find()->where(['billId'=>$bill->billId])->all();
        
        if ($billcontents != null){
            foreach ($billcontents as $i=>$content){
                if(Invcontent::checkServiceInInvoice($content->serviceId,$id)==null){ 
                ?>
             <tr><td><?= $form->field($model, "[$i]serviceId")->checkbox(array('label'=>'','value'=>$content->serviceId)); ?></td> 
              <td><?php echo $content->service->name; ?></td>
              <td><?php echo number_format($content->amount*$content->count); ?></td>  </tr>
                <?php
                echo $form->field($model,"[$i]amount")->hiddenInput(["value"=>$content->amount*$content->count])->label(false);
                $cnt++;
                }
                
            }
        }
    }
}

$agencyfee=Services::getServiceByName('Agency fee');
$dropoff20=Services::getServiceByName('Drop off cost 20ft');
$quantity20=Packages::getQuantityByType(2);
$dropoff40=Services::getServiceByName('Drop off cost 40ft');
$quantity40=Packages::getQuantityByType(4);
$transcost=Services::getServiceByName('Transportation cost');

if ($agencyfee != null){
    if(Invcontent::checkServiceInInvoice($agencyfee->id,$id)==null){
        $cnt++;
?>
<tr><td><?= $form->field($model, "[$cnt]serviceId")->checkbox(array('label'=>'','value'=>$agencyfee->id)); ?></td> 
              <td><?php echo $agencyfee->name; ?></td>
              <td><?php echo number_format(Servicecost::getServiceCost($agencyfee->id)->saleamount*1); ?></td>  </tr>
              
<?php 
echo $form->field($model,"[$cnt]amount")->hiddenInput(["value"=>Servicecost::getServiceCost($agencyfee->id)->saleamount*1])->label(false);
    } }

if ($dropoff20 != null and $quantity20>0){
    if(Invcontent::checkServiceInInvoice($dropoff20->id,$id)==null){
        $cnt++;
?>

<tr><td><?= $form->field($model, "[$cnt]serviceId")->checkbox(array('label'=>'','value'=>$dropoff20->id)); ?></td> 
              <td><?php echo $quantity20.'-'.$dropoff20->name; ?></td>
              <td><?php echo number_format(Servicecost::getServiceCost($dropoff20->id)->saleamount*$quantity20); ?></td>  </tr>
            <?php
            echo $form->field($model,"[$cnt]amount")->hiddenInput(["value"=>Servicecost::getServiceCost($dropoff20->id)->saleamount])->label(false);
    } }
                if ($dropoff40 != null and $quantity40>0){
                    if(Invcontent::checkServiceInInvoice($dropoff40->id,$id)==null){
                        $cnt++;
            ?>
            
            <tr><td><?= $form->field($model, "[$cnt]serviceId")->checkbox(array('label'=>'','value'=>$dropoff40->id)); ?></td> 
              <td><?php echo $quantity40.'-'.$dropoff40->name; ?></td>
              <td><?php echo number_format(Servicecost::getServiceCost($dropoff40->id)->saleamount*$quantity40); ?></td>  </tr>
              
              <?php 
              echo $form->field($model,"[$cnt]amount")->hiddenInput(["value"=>Servicecost::getServiceCost($dropoff40->id)->saleamount])->label(false);
                    } }
                
                if ($transcost != null and ($quantity40+$quantity20)>0){
                    if(Invcontent::checkServiceInInvoice($transcost->id,$id)==null){
                        $cnt++;
              ?>
               <tr><td><?= $form->field($model, "[$cnt]serviceId")->checkbox(array('label'=>'','value'=>$transcost->id)); ?></td> 
              <td><?php echo ($quantity40+$quantity20).'-'.$transcost->name; ?></td>
              <td><?php echo number_format(Servicecost::getServiceCost($transcost->id)->saleamount*($quantity40+$quantity20)); ?></td>  </tr>
              
              <?php 
              echo $form->field($model,"[$cnt]amount")->hiddenInput(["value"=>Servicecost::getServiceCost($transcost->id)->saleamount])->label(false);
                    } }
                    
              echo $form->field($model,"cnt")->hiddenInput(["value"=>$cnt])->label(false);
              ?>

</table>

<table width="30%"><tr><td>
 <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>
</td></tr></table>

 <?php ActiveForm::end(); ?>

</div>