<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\models\FuelrequestSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Active fuel records';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="fuelrequest-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p align="right">
        <?= Html::a('new request', ['carselect'], ['class' => 'btn btn-success']) ?>
    </p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],
            'truckId',
            [
                'attribute'=>'driverId',
                'value'=>function ($model, $key, $index, $widget) {return  $model->driver->user->fullName; },
                ],
                [
                    'attribute'=>'fueldate',
                    'value'=>function ($model, $key, $index, $widget) {return  date('d-m-Y',strtotime($model->fueldate)); },
                    ],
            'volume',
            //'lastdistance',
            //'priceperlitre',
            //'status',

            [
                'class' => 'yii\grid\ActionColumn',
                'template'=>'{update}{delete}',
            ],
           
        ],
    ]); ?>
</div>
