<?php

use app\models\Defectivetrucks;
use yii\bootstrap\Modal;
use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model app\models\Defectivetrucks */

$this->title = 'Car workshop status';
$this->params['breadcrumbs'][] = ['label' => 'Defectivetrucks', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="defectivetrucks-view">

   

    <p align="right">
        <?= Html::a('Gateout paper', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
  <?php if($model->outdate=='0000-00-00')  { ?>
         <?= Html::button('Release',['value'=>\yii\helpers\Url::toRoute(['release','id'=>$model->id]),'class' => 'btn btn-success','id'=>'modalButton']) ?>
    <?php } ?>
    </p>
    
     <h3><?= Html::encode($this->title) ?></h3>
    
     <?php 
        Modal::begin([
            'options'=>[
                'tabindex' => false,
            ],
            'header'=>'',
            'id'=>'modal',
            'size'=>'modal-lg',
        ]);
        
        echo '<div id="modalContent"></div>';
        
        Modal::end();

?>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'carId',
            [
                'attribute'=>'status',
                'value'=>Defectivetrucks::getStatusValue($model->status),
            ],
            'reason',
            [
                'attribute'=>'indate',
                'value'=>date('d-m-Y',strtotime($model->indate)),
            ],
            [
                'attribute'=>'outdate',
                'value'=>$model->outdate=='0000-00-00'?'Still in':date('d-m-Y',strtotime($model->outdate)),
            ],
        ],
    ]) ?>

</div>

<h3>Assigned spares</h3>

 <table class="table table-striped table-bordered table-hover">
                              <thead> <tr><th>#</th><th>Spare</th><th>Quantity</th></tr></thead>
                              <?php 
                              $spares= Defectivetrucks::getTruckcontent($model->carId,$model->indate);
                              if ($spares != null){ for ($i=0; $i<count($spares); $i++) {
                              ?>
                              <tbody><tr><td><?php echo $i+1; ?></td><td><?php echo $spares[$i]['spare']; ?></td><td><?php echo $spares[$i]['quantity']; ?></td></tr></tbody>
                              
                              <?php } }  ?>
                              
 </table>
                              
                              
                              
                              
                              
                              
                              
