<?php

use yii\helpers\Html;
use yii\grid\GridView;
use app\models\Cfile;

/* @var $this yii\web\View */
/* @var $searchModel app\models\CfileSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'All active files';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="cfile-index">

    <h3><?= Html::encode($this->title) ?></h3>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p align="right">
        <?= Html::a('New file', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'blnumber',
            [
                'attribute'=>'shipmenttype',
                'value'=>function ($model, $key, $index, $widget) {return Cfile::getShipmentTypename($model->shipmenttype); }
            ],
            [
                'attribute'=>'incoterm',
                'value'=>function ($model, $key, $index, $widget) {return Cfile::getIncotermName($model->incoterm); }
            ],
            [
                'attribute'=>'delivery',
                'value'=>function ($model, $key, $index, $widget) {return $model->delivery==1?"YES":"NO"; }
            ],
            [
                'attribute'=>'dangestatus',
                'value'=>function ($model, $key, $index, $widget) {return $model->dangestatus==1?"YES":"NO"; }
            ],
            [
                'label'=>' ',
                'format' => 'raw',
                'value'=>function ($model, $key, $index, $widget) {
                return Html::a('',['docsupload/index','id'=>$model->id],['class' => 'glyphicon glyphicon-tasks']);
                },
                ],
                ['class' => 'yii\grid\ActionColumn',
                    'template'=>'{update}'
                ],
                
                ['class' => 'yii\grid\ActionColumn',
                    'template'=>'{delete}'
                ],
        ],
    ]); ?>
</div>
