<?php

use app\models\Uzers;
use yii\bootstrap\Modal;
use yii\helpers\Html;
use yii\widgets\DetailView;
use app\models\Trailers;
use app\models\Cardrivers;

/* @var $this yii\web\View */
/* @var $model app\models\Cars */

$this->title = $model->plateno;
$this->params['breadcrumbs'][] = ['label' => 'Cars', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="cars-view">

<table width="100%">
<tr>
<td style ="border-bottom:1px solid black;"><h4>HORSE: <?php echo mb_strtoupper($model->plateno); ?></h4></td>
<td style ="border-bottom:1px solid black;"><h4>TRAILER: <?php echo mb_strtoupper(Trailers::getActiveTrailer($model->plateno)); ?> </h4>
</td>
<td style ="border-bottom:1px solid black;"><h4>DRIVER: <?php echo mb_strtoupper(Cardrivers::getActiveDriver($model->plateno)); ?></h4>
</td>
<td style ="border-bottom:1px solid black;">
<?php if (mb_strtolower($model->type->name) != 'trailer'){ ?>
<?= Html::button('Set trailer & driver',['value'=>\yii\helpers\Url::toRoute(['cardrivers/create','id'=>$model->plateno]),'class' => 'btn btn-success','id'=>'modalButton']) ?>
<?php } ?>
</td>
</tr>
</table>

    
    &nbsp;


     <?php 
    
     Modal::begin([
         'options'=>[
             'tabindex' => false,
         ],
         'header'=>'',
         'id'=>'modal',
         'size'=>'modal-lg',
     ]);
     
     echo '<div id="modalContent"></div>';
     
     Modal::end();
    
    ?>


    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            [
                'attribute'=>'typeId',
                'value'=>$model->type->name.'-'.$model->type->model,
                ],
            'plateno',
            
            [
                'attribute'=>'driver',
                'value'=>Cardrivers::getActiveDriver($model->plateno),
            ],
            [
                'attribute'=>'trailer',
                'value'=>Trailers::getActiveTrailer($model->plateno),
            ],
            
            [
                'attribute'=>'status',
                'value'=> Uzers::getStatus($model->status),
            ],
            [
                'attribute'=>'datepurchased',
                'value'=>date('d-m-Y',strtotime($model->datepurchased)),
            ],
        ],
    ]) ?>

</div>
