<?php

use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\jui\AutoComplete;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use app\models\Cars;
use app\models\Cartype;

/* @var $this yii\web\View */
/* @var $model app\models\Cars */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="cars-form">

    <?php $form = ActiveForm::begin([
        'fieldConfig' => [
            'template' => " <div class='row'><div class='col-xs-11'>{label}{input}{error}{hint}</div></div>",
        ],
    ]); ?>
    
    <?php 
    $carmodels = ArrayHelper:: map (Cartype::find()->orderBy('name ASC')-> all() , 'id' ,function($model, $defaultValue){ return $model->name.'-'.$model->model; });
?>

<table width='100%' class="outtable">
<tr>

<td><?= $form->field($model, 'status')->dropdownList([
        1 => 'Active', 
        0 => 'Dormant'
    ],
     [
         'style'=>'length:20px',
         'prompt'=>'-select-'
         
     ]
);?></td>

<td> <?= $form->field($model, 'typeId')->dropDownList($carmodels,['prompt' =>'-Select model-']) ?> </td>

 <td> <?= $form->field($model, 'plateno')->textInput(['maxlength' => true]) ?> </td>

    <td>
    <?php 
    echo DatePicker::widget([
    'model' => $model,
    'attribute' => 'datepurchased',
    'options' => ['placeholder' => 'Purchase Date'],
    'pluginOptions' => [
        'orientation' => 'bottom',
        'format' => 'dd-M-yyyy',
        'todayHighlight' => true
    ]
]);
?>
    </td>
    
    <td>&nbsp;</td>

   <td> <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div> </td></tr>
    
    </table>

    <?php ActiveForm::end(); ?>

</div>
