<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "wstoredispatch".
 *
 * @property int $id
 * @property int $byy
 * @property string $date
 * @property string $truckId
 *
 * @property Dispatchcontents[] $dispatchcontents
 * @property Cars $truck
 */
class Wstoredispatch extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $from, $to; 
    public static function tableName()
    {
        return 'wstoredispatch';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['byy', 'date', 'truckId'], 'required'],
            [['date'], 'safe'],
            [['truckId'], 'string', 'max' => 7],
            [['truckId'], 'exist', 'skipOnError' => true, 'targetClass' => Cars::className(), 'targetAttribute' => ['truckId' => 'plateno']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'byy' => 'Requested by',
            'date' => 'Date',
            'truckId' => 'Truck',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDispatchcontents()
    {
        return $this->hasMany(Dispatchcontents::className(), ['dispatchId' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTruck()
    {
        return $this->hasOne(Cars::className(), ['plateno' => 'truckId']);
    }
    
    public function checkDublicate($truckId){
        
        $dispatch= Wstoredispatch::find()->where(['truckId'=>$truckId,'date'=>date('Y-m-d')])->all();
        
        return $dispatch;
    }
    
    public function getCarDispatchesByTime($carId,$from,$to){
        
        $cars= Wstoredispatch::find()->
        where("date >= '$from' and date <= '$to' and truckId='$carId'")->all();
        
        return $cars;
        
    }
    
    public function getCarCostByTime($carId,$from,$to){
        
        $total=0;
        
        $dispatches=Wstoredispatch::getCarDispatchesByTime($carId,$from,$to);
        if ($dispatches != null){
            foreach ($dispatches as $dispatch){
                $contents= Dispatchcontents::find()->where(['dispatchId'=>$dispatch->id])->all();
                if ($contents != null){
                    foreach ($contents as $content){
                        $price=Billcontent::checkServiceAmountInBill($content->store->serviceId,$content->store->billId);
                        if ($price != null) { $total=$total+ $price*$content->quantity; }
                    }
                }
                
            }
        }
        return $total;
    }

}
