<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "wshopbills".
 *
 * @property int $id
 * @property int $billid
 * @property int $status
 *
 * @property Bills $bill
 */
class Wshopbills extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'wshopbills';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['billid'], 'required'],
            [['billid', 'status'], 'integer'],
            [['billid'], 'exist', 'skipOnError' => true, 'targetClass' => Bills::className(), 'targetAttribute' => ['billid' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'billid' => 'Billid',
            'status' => 'Status',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBill()
    {
        return $this->hasOne(Bills::className(), ['id' => 'billid']);
    }
}
