<?php

namespace app\models;

use Yii;
use yii\web\IdentityInterface;

/**
 * This is the model class for table "uzers".
 *
 * @property int $id
 * @property string $firstname
 * @property string $secondname
 * @property string $lastname
 * @property string $address
 * @property string $mobilephone
 * @property string $birthdate
 * @property string $employeddate
 * @property int $roleid
 * @property string $username
 * @property string $password
 * @property string $password_hash
 * @property string $salary
 * @property string $bankacc
 * @property string $nssfno
 * @property int $company
 * @property int $status
 *
 * @property Roles $role
 */
class Uzers extends \yii\db\ActiveRecord implements IdentityInterface
{
    /**
     * {@inheritdoc}
     */
    public $repeatpassword,$oldpassword;
    
    public static function tableName()
    {
        return 'uzers';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['firstname', 'secondname', 'lastname', 'address', 'mobilephone', 'birthdate', 'employeddate', 'company','authKey'], 'required'],
            [['birthdate', 'employeddate'], 'safe'],
            [['company', 'status'], 'integer'],
            ['username', 'unique', 'targetClass' => 'app\models\Uzers', 'message' => 'This username is already taken'],
            [['firstname', 'secondname', 'lastname', 'address', 'username','licence'], 'string', 'max' => 35],
            [['mobilephone'], 'string', 'max' => 13],
            [['authKey'], 'string', 'max' => 50],
            [['password','oldpassword','repeatpassword'], 'string', 'max' => 225],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'firstname' => 'Firstname',
            'secondname' => 'Secondname',
            'lastname' => 'Lastname',
            'address' => 'Address',
            'mobilephone' => 'Mobile phone',
            'birthdate' => 'Birth date',
            'employeddate' => 'Employed date',
            'username' => 'Username',
            'password' => 'Password',
            'company' => 'Company',
            'status' => 'Status',
            'licence'=>'Licence #',
            'repeatpassword'=>'Repeat password',
            'oldpassword'=>'Old password',
            
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    
    public function validatePassword ($password)
    {
        
        return Yii::$app->security->validatePassword($password, $this->password);
    }
    
    /**
     * Generates password hash from password and sets it to the model
     *
     * @param string $password
     */
    public function setPassword($password)
    {
        return Yii::$app->security->generatePasswordHash($password);
    }
    
    public static function findByUsername ($username)
    {
        //print_r(self:: findOne([ 'username' => $username ] ));
        return self :: findOne([ 'username' => $username ]);//, 'status' => self::STATUS_ACTIVE
    }
    
    public function getFullName() {
        return $this->firstname . ' ' . $this->secondname . ' ' . $this->lastname;
    }
    public function getId()
    {
        return $this->id;
    }

    public function validateAuthKey($authKey)
    {
        return $this->authKey===$authKey ;
    }
    
    public function generateAuthKey(){
        return Yii::$app->security->generateRandomString();
    }

    public function getAuthKey()
    {
        return $this->authKey;
    }
    
 
    
    public function getStatus($id)
    {
        $val='Active';
        if ($id==0)$val='Dormant';
        
        return $val;
    }

    public static function findIdentity($id)
    {
        return self::findOne($id);
    }

    public static function findIdentityByAccessToken($token, $type = null)
    {}
    
    public function getAgeByBdate($bdate){
        
        $d1= date_create(date('Y-m-d'));
        $d2= date_create($bdate);
        
        $interval=date_diff($d1,$d2);
        
        return $interval->format('%y Years');
    }
    
    public function getIdleDays($date){
        
        $d1= date_create(date('Y-m-d'));
        $d2= date_create($date);
        
        $interval=date_diff($d1,$d2);
        
        return $interval->format('%d Days');
    }
    
    public function checkDublicate($fname,$lname){
        
        $ret=null;
        $users= Uzers::find()->where(['firstname'=>$fname,'lastname'=>$lname])->all();
        
        if ($users != null){
            foreach ($users as $user){
                $ret=$user;
            }
        }
        
        return $ret;
    }
    
    public function getCompanyname($id){
        
        if ($id==1) return 'ITL';
        elseif ($id==2) return 'IMSL';
        elseif ($id==3) return 'EBM TZ'; 
        elseif ($id==4) return 'TASHICOL';
        
    }

}
