<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "ukers".
 *
 * @property int $id
 * @property string $firstname
 * @property string $secondname
 * @property string $lastname
 * @property string $address
 * @property string $phoneNo1
 * @property string $phoneNo2
 * @property string $employedDate
 * @property int $status
 * @property string $username
 * @property string $password
 * @property int $rankId
 * @property int $salary
 */
class Ukers extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'ukers';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['phoneNo2', 'salary'], 'required'],
            [['employedDate'], 'safe'],
            [['status', 'rankId', 'salary'], 'integer'],
            [['firstname', 'secondname', 'lastname', 'phoneNo2', 'username'], 'string', 'max' => 30],
            [['address'], 'string', 'max' => 45],
            [['phoneNo1'], 'string', 'max' => 10],
            [['password'], 'string', 'max' => 35],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'firstname' => 'Firstname',
            'secondname' => 'Secondname',
            'lastname' => 'Lastname',
            'address' => 'Address',
            'phoneNo1' => 'Phone No1',
            'phoneNo2' => 'Phone No2',
            'employedDate' => 'Employed Date',
            'status' => 'Status',
            'username' => 'Username',
            'password' => 'Password',
            'rankId' => 'Rank ID',
            'salary' => 'Salary',
        ];
    }
    
    public function getUserCom($f,$l){
        $ukers= Ukers::find()->where(['firstname'=>$f, 'lastname'=>$l])->all();
        $return=null;
        
        if ($ukers != null){
            foreach ($ukers as $uker){
                
                if ($uker->salary!=0) $return=$uker;
            }
        }
        
        return $return;
    }
}
