<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "salaries".
 *
 * @property int $id
 * @property int $userId
 * @property string $amount
 * @property string $date
 *
 * @property Deductions[] $deductions
 * @property Overtime[] $overtimes
 * @property Uzers $user
 */
class Salaries extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public $reqdate;
    
    public static function tableName()
    {
        return 'salaries';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['userId', 'amount','bankacc','ssfacc', 'date'], 'required'],
            [['userId'], 'integer'],
            [['amount'], 'number'],
            [['date'], 'safe'],
            [['userId'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['userId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'userId' => 'User ID',
            'amount' => 'Amount',
            'date' => 'Date',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDeductions()
    {
        return $this->hasMany(Deductions::className(), ['salaryId' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getOvertimes()
    {
        return $this->hasMany(Overtime::className(), ['salaryId' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'userId']);
    }
    
    public function getUserSalary($id){
        $ret=null;
        $salary= Salaries::find()->where(['userId'=>$id])->orderBy('id Desc')->all();
        
        if ($salary != null){
            foreach ($salary as $sala){
                $ret=$sala;
                break;
            }
        }
        
        return $ret;
    }
    
    public function checkDublicate($id,$amount,$bacc, $ssacc){
        
        $salary= Salaries::find()->where(['userId'=>$id,'amount'=>$amount,'bankacc'=>$bacc,'ssfacc'=>$ssacc])->all();
        
        return $salary;
    }
}
