<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Routing;

/**
 * RoutingSearch represents the model behind the search form of `app\models\Routing`.
 */
class RoutingSearch extends Routing
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'packageId', 'byy'], 'integer'],
            [['gatepass', 'routedate', 'onn'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Routing::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'packageId' => $this->packageId,
            'routedate' => $this->routedate,
            'byy' => $this->byy,
            'onn' => $this->onn,
        ]);

        $query->andFilterWhere(['like', 'gatepass', $this->gatepass]);

        return $dataProvider;
    }
}
