<?php

namespace app\models;

use Yii;
use app\models\Routing;

/**
 * This is the model class for table "packages".
 *
 * @property int $id
 * @property int $type
 * @property string $containerno
 * @property string $volumekg
 * @property int $fileId
 * @property int $byy
 * @property string $onn
 *
 * @property Uzers $byy0
 * @property Cfile $file
 * @property Routing[] $routings
 */
class Packages extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'packages';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['type', 'containerno', 'volumekg', 'fileId', 'byy', 'onn'], 'required'],
            [['type', 'fileId', 'byy'], 'integer'],
            [['volumekg'], 'number'],
            [['onn'], 'safe'],
            [['containerno'], 'string', 'max' => 20],
            [['byy'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['byy' => 'id']],
            [['fileId'], 'exist', 'skipOnError' => true, 'targetClass' => Cfile::className(), 'targetAttribute' => ['fileId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'type' => 'Load type',
            'containerno' => 'Container #',
            'volumekg' => 'Volume(kg)',
            'fileId' => 'File ID',
            'byy' => 'Byy',
            'onn' => 'Onn',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getByy0()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'byy']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getFile()
    {
        return $this->hasOne(Cfile::className(), ['id' => 'fileId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRoutings()
    {
        return $this->hasMany(Routing::className(), ['packageId' => 'id']);
    }
    
    public function checkDublicate($cn){
        $packages= Packages::find()->where(['containerno'=>$cn,'fileId'=>\Yii::$app->session->get('fileId')])->all();
        $ret=null;
        if ($packages!= null){
            foreach ($packages as $package){
                $ret=$package;
            }
        }
        
        return $ret;
    }
    
    public function getQuantityByType($ty){
        $packages= Packages::find()->where(['type'=>$ty,'fileId'=>\Yii::$app->session->get('fileId')])->all();
        
        return count($packages);
    }
    
    public function getType($id){
        if ($id==2) return '20ft';
        elseif ($id==4) return '40ft';
        elseif ($id==3) return 'Others';
    }
}
