<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Offuels;

/**
 * OffuelsSearch represents the model behind the search form of `app\models\Offuels`.
 */
class OffuelsSearch extends Offuels
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'driverId', 'fuelId'], 'integer'],
            [['truckId', 'date', 'reasons'], 'safe'],
            [['amount'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Offuels::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'driverId' => $this->driverId,
            'amount' => $this->amount,
            'date' => $this->date,
            'fuelId' => $this->fuelId,
        ]);

        $query->andFilterWhere(['like', 'truckId', $this->truckId])
            ->andFilterWhere(['like', 'reasons', $this->reasons]);

        return $dataProvider;
    }
}
