<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "invoices".
 *
 * @property int $id
 * @property int $accId
 * @property string $date
 * @property int $userId
 * @property int $paid
 * @property int $company
 * @property int $type
 * @property int $tax
 * @property int $currency
 *
 * @property Invcontent[] $invcontents
 * @property Accounts $acc
 * @property Uzers $user
 * @property Invopayments[] $invopayments
 */
class Invoices extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    
    public $amount,$paida,$balance,$from,$to,$clienttype;
    
    public static function tableName()
    {
        return 'invoices';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['accId', 'date', 'userId', 'currency'], 'required'],
            [['accId', 'userId', 'paid', 'company', 'type', 'tax', 'currency'], 'integer'],
            [['date'], 'safe'],
            [['accId'], 'exist', 'skipOnError' => true, 'targetClass' => Accounts::className(), 'targetAttribute' => ['accId' => 'id']],
            [['userId'], 'exist', 'skipOnError' => true, 'targetClass' => Uzers::className(), 'targetAttribute' => ['userId' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'accId' => 'Accounted to',
            'date' => 'Invoice date',
            'userId' => 'User ID',
            'paid' => 'Paid',
            'company' => 'Company',
            'type' => 'Invoice type',
            'tax' => 'Tax',
            'currency' => 'Currency',
            'paida'=>'Paid',
            'clienttype'=>'Search by'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getInvcontents()
    {
        return $this->hasMany(Invcontent::className(), ['invId' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAcc()
    {
        return $this->hasOne(Accounts::className(), ['id' => 'accId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(Uzers::className(), ['id' => 'userId']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getInvopayments()
    {
        return $this->hasMany(Invopayments::className(), ['invId' => 'id']);
    }
    
    public function getInvoiceType($id){
        
        if ($id==1) return 'Invoice';
        elseif ($id==2) return 'Profoma invoice';
        elseif ($id==3) return 'Debit notes';
    }
    
    public function getInvoiceNo($typ,$invo){
        
        $fileId=Invoices::findOne($invo)->fileId;
        $accId=Invoices::findOne($invo)->accId;
        
        $alpha='A';
        $cnt=1;
        $return=null;
        $iN=$invo;
       
        
        
      
        
        $accInvoices= Invoices::find()->where(['accId'=>$accId])->orderBy(['id'=>SORT_ASC])->all();
        $b=count($accInvoices);
        if($fileId!=0) { $invoices= Invoices::find()->where(['fileId'=>$fileId])->all();
       
            if ($invoices != null){
                foreach ($invoices as $invoice){
                    if ($cnt !=1){
                        $alpha++;
                    }
                    $b=$b+$cnt;
                    $cnt++;
                    
                    if ($invoice->id==$invo) break;
                }
            }
            
        }else{
            if ($accInvoices != null){
                $c=1;
                foreach ($accInvoices as $acInv){
                    if ($acInv->id==$invo){ $b=$c; break; }
                    $c++;
                }
            }
            
        }
        
        if ($typ==1){
            $return=($b).$alpha.'/'.date('Y',strtotime(Invoices::findOne($invo)->date));
        }else {
            $return=($b).$alpha.'/'.date('Y',strtotime(Invoices::findOne($invo)->date));
        }
        
        return $return;
        
    }
}
