<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Fuelrequest;

/**
 * FuelrequestSearch represents the model behind the search form of `app\models\Fuelrequest`.
 */
class FuelrequestSearch extends Fuelrequest
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'truckId', 'driverId', 'status'], 'integer'],
            [['fueldate', 'recorddate'], 'safe'],
            [['volume', 'lastdistance', 'priceperlitre'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Fuelrequest::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'truckId' => $this->truckId,
            'driverId' => $this->driverId,
            'fueldate' => $this->fueldate,
            'recorddate' => $this->recorddate,
            'volume' => $this->volume,
            'lastdistance' => $this->lastdistance,
            'priceperlitre' => $this->priceperlitre,
            'status' => $this->status,
        ]);

        return $dataProvider;
    }
}
